/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PlatformTarget;
import com.android.sdklib.SdkConstants;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AddOnTarget
implements IAndroidTarget {
    private static final String ADD_ON_FORMAT = "%s:%s:%s";
    private final String mLocation;
    private final PlatformTarget mBasePlatform;
    private final String mName;
    private final ISystemImage[] mSystemImages;
    private final String mVendor;
    private final int mRevision;
    private final String mDescription;
    private final boolean mHasRenderingLibrary;
    private final boolean mHasRenderingResources;
    private String[] mSkins;
    private String mDefaultSkin;
    private IAndroidTarget.IOptionalLibrary[] mLibraries;
    private int mVendorId = 0;

    AddOnTarget(String string, String string2, String string3, int n, String string4, ISystemImage[] iSystemImageArray, Map<String, String[]> map, boolean bl, boolean bl2, PlatformTarget platformTarget) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.mLocation = string;
        this.mName = string2;
        this.mVendor = string3;
        this.mRevision = n;
        this.mDescription = string4;
        this.mHasRenderingLibrary = bl;
        this.mHasRenderingResources = bl2;
        this.mBasePlatform = platformTarget;
        this.mSystemImages = iSystemImageArray == null ? new ISystemImage[]{} : iSystemImageArray;
        Arrays.sort(this.mSystemImages);
        if (map != null) {
            this.mLibraries = new IAndroidTarget.IOptionalLibrary[map.size()];
            int n2 = 0;
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String string5 = entry.getValue()[0];
                String string6 = entry.getValue()[1];
                this.mLibraries[n2++] = new OptionalLibrary(string5, this.mLocation + SdkConstants.OS_ADDON_LIBS_FOLDER + string5, entry.getKey(), string6);
            }
        }
    }

    @Override
    public String getLocation() {
        return this.mLocation;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public ISystemImage getSystemImage(String string) {
        for (ISystemImage iSystemImage : this.mSystemImages) {
            if (!iSystemImage.getAbiType().equals(string)) continue;
            return iSystemImage;
        }
        return null;
    }

    @Override
    public ISystemImage[] getSystemImages() {
        return this.mSystemImages;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public String getFullName() {
        return String.format("%1$s (%2$s)", this.mName, this.mVendor);
    }

    @Override
    public String getClasspathName() {
        return String.format("%1$s [%2$s]", this.mName, this.mBasePlatform.getClasspathName());
    }

    @Override
    public String getShortClasspathName() {
        return String.format("%1$s [%2$s]", this.mName, this.mBasePlatform.getVersionName());
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mBasePlatform.getVersion();
    }

    @Override
    public String getVersionName() {
        return this.mBasePlatform.getVersionName();
    }

    @Override
    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public boolean isPlatform() {
        return false;
    }

    @Override
    public IAndroidTarget getParent() {
        return this.mBasePlatform;
    }

    @Override
    public String getPath(int n) {
        switch (n) {
            case 5: {
                return this.mLocation + SdkConstants.OS_SKINS_FOLDER;
            }
            case 19: {
                return this.mLocation + "docs" + File.separator + "reference";
            }
            case 10: {
                if (this.mHasRenderingLibrary) {
                    return this.mLocation + "data" + File.separator + "layoutlib.jar";
                }
                return this.mBasePlatform.getPath(n);
            }
            case 11: {
                if (this.mHasRenderingResources) {
                    return this.mLocation + "data" + File.separator + "res";
                }
                return this.mBasePlatform.getPath(n);
            }
            case 12: {
                if (this.mHasRenderingResources) {
                    return this.mLocation + "data" + File.separator + "fonts";
                }
                return this.mBasePlatform.getPath(n);
            }
            case 4: {
                File[] fileArray;
                File file = new File(this.mLocation, "samples");
                if (!file.isDirectory() || (fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                })) == null || fileArray.length <= 0) break;
                return file.getAbsolutePath();
            }
        }
        return this.mBasePlatform.getPath(n);
    }

    @Override
    public boolean hasRenderingLibrary() {
        return this.mHasRenderingLibrary || this.mHasRenderingResources;
    }

    @Override
    public String[] getSkins() {
        return this.mSkins;
    }

    @Override
    public String getDefaultSkin() {
        return this.mDefaultSkin;
    }

    @Override
    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return this.mLibraries;
    }

    @Override
    public String[] getPlatformLibraries() {
        return this.mBasePlatform.getPlatformLibraries();
    }

    @Override
    public String getProperty(String string) {
        return this.mBasePlatform.getProperty(string);
    }

    @Override
    public Integer getProperty(String string, Integer n) {
        return this.mBasePlatform.getProperty(string, n);
    }

    @Override
    public Boolean getProperty(String string, Boolean bl) {
        return this.mBasePlatform.getProperty(string, bl);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mBasePlatform.getProperties();
    }

    @Override
    public int getUsbVendorId() {
        return this.mVendorId;
    }

    @Override
    public boolean canRunOn(IAndroidTarget iAndroidTarget) {
        if (iAndroidTarget == this) {
            return true;
        }
        if (this.mLibraries == null || this.mLibraries.length == 0) {
            return this.mBasePlatform.canRunOn(iAndroidTarget);
        }
        if (!this.mVendor.equals(iAndroidTarget.getVendor()) || !this.mName.equals(iAndroidTarget.getName())) {
            return false;
        }
        return this.mBasePlatform.canRunOn(iAndroidTarget);
    }

    @Override
    public String hashString() {
        return String.format(ADD_ON_FORMAT, this.mVendor, this.mName, this.mBasePlatform.getVersion().getApiString());
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AddOnTarget) {
            AddOnTarget addOnTarget = (AddOnTarget)object;
            return this.mVendor.equals(addOnTarget.mVendor) && this.mName.equals(addOnTarget.mName) && this.mBasePlatform.getVersion().equals(addOnTarget.mBasePlatform.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(IAndroidTarget iAndroidTarget) {
        if (this == iAndroidTarget) {
            return 0;
        }
        int n = this.getVersion().compareTo(iAndroidTarget.getVersion());
        if (n == 0) {
            if (iAndroidTarget.isPlatform()) {
                return 1;
            }
            AddOnTarget addOnTarget = (AddOnTarget)iAndroidTarget;
            int n2 = this.mVendor.compareTo(addOnTarget.mVendor);
            if (n2 == 0) {
                return this.mName.compareTo(addOnTarget.mName);
            }
            return n2;
        }
        return n;
    }

    public String toString() {
        return String.format("AddonTarget %1$s rev %2$d (based on %3$s)", this.getVersion(), this.getRevision(), this.getParent().toString());
    }

    void setSkins(String[] stringArray, String string) {
        this.mDefaultSkin = string;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(Arrays.asList(this.mBasePlatform.getSkins()));
        this.mSkins = hashSet.toArray(new String[hashSet.size()]);
    }

    void setUsbVendorId(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("VendorId must be > 0");
        }
        this.mVendorId = n;
    }

    private static final class OptionalLibrary
    implements IAndroidTarget.IOptionalLibrary {
        private final String mJarName;
        private final String mJarPath;
        private final String mName;
        private final String mDescription;

        OptionalLibrary(String string, String string2, String string3, String string4) {
            this.mJarName = string;
            this.mJarPath = string2;
            this.mName = string3;
            this.mDescription = string4;
        }

        public String getJarName() {
            return this.mJarName;
        }

        public String getJarPath() {
            return this.mJarPath;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

