/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.App;
import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.ReleaseNotes;
import com.crashlytics.api.Software;
import com.crashlytics.api.User;
import com.crashlytics.api.ota.AppVersion;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.api.ota.Tester;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public interface WebApi {
    public static final String JSON_USER_EMAIL = "email";
    public static final String JSON_USER_NAME = "name";
    public static final String JSON_USER_PASSWORD = "password";
    public static final String JSON_SESSION_TOKEN = "token";
    public static final String JSON_ORGS_ARRAY = "organizations";
    public static final String JSON_ORG_ID = "id";
    public static final String JSON_ORG_ALIAS = "alias";
    public static final String JSON_ORG_APPS_COUNTS = "apps_counts";
    public static final String JSON_ORG_NAME = "name";
    public static final String JSON_ORG_API_KEY = "api_key";
    public static final String JSON_ORG_BUILD_SECRET = "build_secret";
    public static final String JSON_PLATFORM_ANDROID = "android";
    public static final String DEFAULT_BASE_API_URL = "https://api.crashlytics.com";
    public static final String URL_SIGNUP = "http://www.crashlytics.com";
    public static final String URL_FORGOT_PW = "http://www.crashlytics.com/accounts/password/new";
    public static final String URL_SECURITY = "http://crash.io/LKHyRj";
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String MIME_TYPE_JSON = "application/json";
    public static final String PLATFORM_ANDROID = "android";

    public void logout();

    public User authenticateUser(String var1, String var2) throws IOException;

    public void asyncAuthenticate(String var1, String var2, ApiCallback var3);

    public User authenticateWithToken(String var1) throws IOException;

    public void asyncAuthenticateWithToken(String var1, ApiCallback var2);

    public List<Organization> getOrgs(boolean var1) throws IOException, AuthenticationException;

    public void fetchApps(ApiCallback var1);

    public List<App> getApps(Organization var1, boolean var2) throws IOException, AuthenticationException;

    public List<App> getApps(boolean var1) throws IOException, AuthenticationException;

    public List<Issue> getIssues(App var1, boolean var2) throws IOException, AuthenticationException;

    public boolean sendFile(URL var1, File var2, String var3, String var4, Map<String, String> var5) throws IOException;

    public boolean downloadFile(URL var1, File var2) throws IOException;

    public Software getSoftwareIntegration(Organization var1, String var2, String var3, String var4) throws IOException;

    public Software getSoftwareIntegration(String var1, String var2, String var3, String var4) throws IOException;

    public Software getAndroidSDK(Organization var1, String var2) throws IOException;

    public Software getAndroidSDK(String var1, String var2) throws IOException;

    public String getBaseApiUrl();

    public User getCurrentUser();

    public void setUserAgent(String var1);

    public void setClientType(String var1);

    public void setClientVersion(String var1);

    public void setToolId(String var1);

    public void setToolVersion(String var1);

    public void setOperatingSystem(String var1);

    public boolean createDistribution(String var1, String var2, AppRelease var3, DistributionData var4) throws AuthenticationException, IOException;

    public JSONObject inviteTester(String var1, String var2, String var3, String var4) throws AuthenticationException, IOException;

    public boolean updateRelease(String var1, String var2, String var3, String var4, String var5, List<String> var6, List<String> var7) throws AuthenticationException, IOException;

    public List<AppVersion> getAppVersions(String var1, String var2) throws AuthenticationException, IOException;

    public List<Tester> getTesters(String var1, App var2) throws IOException;

    public ReleaseNotes getReleaseNotes(String var1, String var2, String var3, String var4, String var5) throws AuthenticationException, IOException;

    public boolean setReleaseNotes(String var1, String var2, String var3, String var4, String var5, ReleaseNotes var6) throws AuthenticationException, IOException;

    public List<ReleaseSummary> getReleaseSummaries(String var1, String var2) throws AuthenticationException, IOException;

    public Release getRelease(String var1, String var2, String var3, String var4, String var5) throws AuthenticationException, IOException;

    public boolean updateAccess(String var1, String var2, String var3, String var4, String var5, long var6, boolean var8) throws AuthenticationException, IOException;

    public void asyncNotifyBuildEvent(String var1, String var2, String var3, String var4);

    public App getApp(String var1) throws IOException, AuthenticationException;

    public Organization getOrg(String var1) throws IOException, AuthenticationException;

    public static enum AppStatus {
        CONFIGURED;

    }

    public static class ApiCallbackAdapter
    implements ApiCallback {
        @Override
        public void onAuthenticated(WebApi api, User user) {
        }

        @Override
        public void onRetrievedOrganizations(WebApi api, List<Organization> organizations) {
        }

        @Override
        public void onRetrievedApps(WebApi api, List<App> apps) {
        }

        @Override
        public void onAuthenticateException(WebApi api, Exception exception) {
        }

        @Override
        public void onOrganizationException(WebApi api, Exception exception) {
        }

        @Override
        public void onAppException(WebApi api, Exception exception) {
        }
    }

    public static interface ApiCallback {
        public void onAuthenticated(WebApi var1, User var2);

        public void onAuthenticateException(WebApi var1, Exception var2);

        public void onRetrievedOrganizations(WebApi var1, List<Organization> var2);

        public void onOrganizationException(WebApi var1, Exception var2);

        public void onRetrievedApps(WebApi var1, List<App> var2);

        public void onAppException(WebApi var1, Exception var2);
    }
}

