/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ApiUtils;
import com.crashlytics.api.ota.Device;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseEntry;
import com.crashlytics.api.ota.ReleaseEntryEvent;
import com.crashlytics.api.ota.ReleaseEntryInvitation;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import java.util.ArrayList;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ReleaseJsonTransform {
    private static final String SUMMARY = "summary";
    private static final String AUTHORIZED_DEVICES = "authorized_devices";
    private static final String ENTRIES = "entries";
    private static final String ID = "id";
    private static final String EMAIL_STATUS = "email_status";
    private static final String INVITATION_ID = "invitation_id";
    private static final String OVERALL_STATUS_MODIFIED_AT = "overall_status_modified_at";
    private static final String EMAIL = "email";
    private static final String EVENTS = "events";
    private static final String NAME = "name";
    private static final String OVERALL_STATUS = "overall_status";
    private static final String DEVICES = "devices";
    private static final String INVITATION = "invitation";
    private static final String ACCESS = "access";
    private static final String STATUS = "status";
    private static final String MODIFIED_AT = "modified_at";
    private static final String EVENT = "event";
    private static final String EVENT_AT = "event_at";
    private static final String BUILD_INSTANCE_ID = "build_instance_id";
    private final ReleaseSummariesJsonTransform releaseSummaryTransform = new ReleaseSummariesJsonTransform();

    public Release createReleaseFrom(JSONObject releaseJson) {
        if (releaseJson == null) {
            return null;
        }
        JSONObject summaryJson = (JSONObject)releaseJson.get(SUMMARY);
        ReleaseSummary summary = this.releaseSummaryTransform.createSingleReleaseSummaryFrom(summaryJson);
        JSONArray authorizedDevices = (JSONArray)releaseJson.get(AUTHORIZED_DEVICES);
        JSONArray entriesJson = (JSONArray)releaseJson.get(ENTRIES);
        ArrayList<ReleaseEntry> entries = new ArrayList<ReleaseEntry>();
        for (Object entryObj : entriesJson) {
            JSONObject entryJson = (JSONObject)entryObj;
            entries.add(this.createReleaseEntryFrom(entryJson));
        }
        return new Release(summary, authorizedDevices, entries);
    }

    private ReleaseEntry createReleaseEntryFrom(JSONObject jsonObject) {
        Long testerId = (Long)jsonObject.get(ID);
        String emailStatus = (String)jsonObject.get(EMAIL_STATUS);
        Long invitationId = (Long)jsonObject.get(INVITATION_ID);
        Date overallStatusModifiedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(OVERALL_STATUS_MODIFIED_AT));
        String email = (String)jsonObject.get(EMAIL);
        JSONArray eventsJson = (JSONArray)jsonObject.get(EVENTS);
        ArrayList<ReleaseEntryEvent> events = new ArrayList<ReleaseEntryEvent>(eventsJson.size());
        for (Object obj : eventsJson) {
            JSONObject eventJson = (JSONObject)obj;
            events.add(this.createReleaseEntryEventFrom(eventJson));
        }
        String name = (String)jsonObject.get(NAME);
        String overallStatus = (String)jsonObject.get(OVERALL_STATUS);
        String access = (String)jsonObject.get(ACCESS);
        JSONArray devicesJson = (JSONArray)jsonObject.get(DEVICES);
        ArrayList<Device> devices = new ArrayList<Device>(devicesJson.size());
        for (Object obj : devicesJson) {
            JSONObject deviceJson = (JSONObject)obj;
            devices.add(new Device(deviceJson));
        }
        ReleaseEntryInvitation invitation = this.createReleaseEntryInvitationFrom((JSONObject)jsonObject.get(INVITATION));
        return new ReleaseEntry(testerId, emailStatus, invitationId, overallStatusModifiedAt, email, events, name, overallStatus, devices, invitation, access);
    }

    private ReleaseEntryEvent createReleaseEntryEventFrom(JSONObject jsonObject) {
        String event = (String)jsonObject.get(EVENT);
        Date eventAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(EVENT_AT));
        String buildInstanceId = (String)jsonObject.get(BUILD_INSTANCE_ID);
        return new ReleaseEntryEvent(event, eventAt, buildInstanceId);
    }

    private ReleaseEntryInvitation createReleaseEntryInvitationFrom(JSONObject jsonObject) {
        long id = (Long)jsonObject.get(ID);
        String status = (String)jsonObject.get(STATUS);
        Date modifiedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(MODIFIED_AT));
        return new ReleaseEntryInvitation(id, status, modifiedAt);
    }
}

