/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.api.AppRelease;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.Utf16ParseStringStrategy;
import com.crashlytics.tools.utils.Utf8ParseStringStrategy;
import com.crashlytics.tools.utils.abx.AbxConstants;
import com.crashlytics.tools.utils.abx.AbxNode;
import com.crashlytics.tools.utils.abx.AbxParser;
import com.crashlytics.tools.utils.abx.AbxUtils;
import com.crashlytics.tools.utils.abx.StringResourcesMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.util.TextUtils;

public class ApkUtils {
    private static final String TAG = "[ApkUtils] ";
    public static final boolean DEBUG_LOGGING = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AppRelease readBuildPropertiesFromApk(File apkFile) {
        ZipInputStream zin = null;
        ZipEntry ze = null;
        Properties buildProperties = new Properties();
        try {
            zin = new ZipInputStream(new FileInputStream(apkFile));
            while ((ze = zin.getNextEntry()) != null) {
                String name;
                if (ze.isDirectory() || !"assets/crashlytics-build.properties".equals(name = ze.getName())) continue;
                buildProperties.load(zin);
                break;
            }
        }
        catch (Exception e) {
            try {
                ApkUtils.logE("Crashlytics could not find assets/crashlytics-build.properties in the APK.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zin);
                throw throwable;
            }
            IOUtils.closeQuietly(zin);
        }
        IOUtils.closeQuietly(zin);
        if (!buildProperties.isEmpty()) {
            String appName = buildProperties.getProperty("app_name");
            String packageName = buildProperties.getProperty("package_name");
            String instanceId = buildProperties.getProperty("build_id");
            String displayVersion = buildProperties.getProperty("version_name");
            String buildVersion = buildProperties.getProperty("version_code");
            return new AppRelease(appName, packageName, instanceId, displayVersion, buildVersion);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AppRelease extractAppDataFromApk(File apk) {
        StringResourcesMap strings;
        AbxNode manifest;
        ZipInputStream zin = null;
        ZipEntry ze = null;
        byte[] manifestBinaryXml = null;
        byte[] stringsBinaryXml = null;
        try {
            zin = new ZipInputStream(new FileInputStream(apk));
            while ((ze = zin.getNextEntry()) != null) {
                AbxConstants.AbxFileType type = ApkUtils.getFileType(ze);
                if (type == null) continue;
                byte[] binaryXml = IOUtils.toByteArray(zin);
                if (type == AbxConstants.AbxFileType.MANIFEST) {
                    manifestBinaryXml = binaryXml;
                    continue;
                }
                if (type != AbxConstants.AbxFileType.STRINGS) continue;
                stringsBinaryXml = binaryXml;
            }
        }
        catch (IOException e) {
            AppRelease binaryXml;
            try {
                ApkUtils.logW("Error opening APK file.", e);
                binaryXml = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zin);
                throw throwable;
            }
            IOUtils.closeQuietly(zin);
            return binaryXml;
        }
        IOUtils.closeQuietly(zin);
        if (manifestBinaryXml == null) {
            ApkUtils.logW("Could not find AndroidManifest.xml in APK.", null);
            return null;
        }
        if (stringsBinaryXml == null) {
            ApkUtils.logW("Could not find resources file in APK.", null);
            return null;
        }
        try {
            manifest = new AbxParser(manifestBinaryXml).parseManifest();
            if (manifest == null) {
                ApkUtils.logW("AndroidManifest.xml is blank.", null);
                return null;
            }
        }
        catch (IOException e) {
            ApkUtils.logW("Could not parse AndroidManifest.xml file.", e);
            return null;
        }
        String packageName = manifest.getAttribute("package");
        if (TextUtils.isEmpty(packageName)) {
            ApkUtils.logW("Could not extract package name from APK.", null);
            return null;
        }
        String buildVersion = manifest.getAttribute("versionCode");
        if (TextUtils.isEmpty(buildVersion)) {
            ApkUtils.logW("Could not extract build version from APK.", null);
            return null;
        }
        String displayVersion = manifest.getAttribute("versionName");
        if (TextUtils.isEmpty(displayVersion)) {
            ApkUtils.logW("Could not extract display version from APK.", null);
            return null;
        }
        AbxNode application = null;
        for (AbxNode node : manifest.getChildren()) {
            if (!"application".equals(node.getName())) continue;
            application = node;
        }
        if (application == null) {
            ApkUtils.logW("Could not find <application> tag in APK manifest file.", null);
            return null;
        }
        String appNameOrId = application.getAttribute("label");
        if (TextUtils.isEmpty(appNameOrId)) {
            ApkUtils.logW("Could not extract application name from APK manifest file.", null);
            return null;
        }
        try {
            strings = new AbxParser(stringsBinaryXml).parseResourceTable(new Utf16ParseStringStrategy());
            ApkUtils.log("Extracted these strings: " + strings);
        }
        catch (IOException e) {
            ApkUtils.logW("Could not parse resources file.", e);
            return null;
        }
        String appName = null;
        String instanceIdentifier = null;
        try {
            appName = ApkUtils.getAppNameFrom(appNameOrId, strings);
            instanceIdentifier = strings.getStringValue("com.crashlytics.android.build_id");
            if (TextUtils.isEmpty(instanceIdentifier)) {
                ApkUtils.logW("Could not find Crashlytics Build ID in resources file.", null);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            try {
                strings = new AbxParser(stringsBinaryXml).parseResourceTable(new Utf8ParseStringStrategy());
                ApkUtils.log("Extracted these strings: " + strings);
                appName = ApkUtils.getAppNameFrom(appNameOrId, strings);
                instanceIdentifier = strings.getStringValue("com.crashlytics.android.build_id");
                if (TextUtils.isEmpty(instanceIdentifier)) {
                    ApkUtils.logW("Could not find Crashlytics Build ID in resources file.", null);
                    return null;
                }
            }
            catch (IOException ioe) {
                ApkUtils.logW("Could not parse resources file.", e);
                return null;
            }
        }
        return new AppRelease(appName, packageName, instanceIdentifier, displayVersion, buildVersion);
    }

    private static String getAppNameFrom(String appNameOrId, StringResourcesMap strings) {
        try {
            int appId = Integer.valueOf(appNameOrId);
            if (!AbxUtils.verifyPackageIdFromResIdIsDefault(appId)) {
                ApkUtils.logW("Extracting app name from other than the application's own package is currently not supported.", null);
                throw new IllegalArgumentException();
            }
            int entryIndex = AbxUtils.entryIndexFromResId(appId);
            appNameOrId = strings.findStringValueByResId(appId);
            ApkUtils.log("appNameOrId: " + appId + "; " + appNameOrId + "; " + entryIndex);
            if (TextUtils.isEmpty(appNameOrId)) {
                ApkUtils.logW("Could not find application name in resources file.", null);
                throw new IllegalArgumentException();
            }
            return appNameOrId;
        }
        catch (NumberFormatException nfe) {
            ApkUtils.log("[ApkUtils] Encountered hard-coded app name in AndroidManifest.xml: " + appNameOrId);
            throw new IllegalArgumentException(nfe);
        }
    }

    private static AbxConstants.AbxFileType getFileType(ZipEntry ze) {
        if (!ze.isDirectory()) {
            String name = ze.getName();
            if (name.equals("AndroidManifest.xml")) {
                return AbxConstants.AbxFileType.MANIFEST;
            }
            if (name.endsWith(".arsc")) {
                return AbxConstants.AbxFileType.STRINGS;
            }
        }
        return null;
    }

    public static void log(String s) {
    }

    public static void logW(String s, Throwable t) {
        DeveloperTools.logW(TAG + s, t);
    }

    public static void logE(String s, Throwable t) {
        DeveloperTools.logE(TAG + s, t);
    }
}

