/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.EnrollmentsJsonTransform;
import com.crashlytics.api.App;
import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.ProgressReportingHttpEntity;
import com.crashlytics.api.Software;
import com.crashlytics.api.User;
import com.crashlytics.api.WebApi;
import com.crashlytics.api.net.auth.OAuthClient;
import com.crashlytics.api.net.proxy.ProtocolScheme;
import com.crashlytics.api.net.proxy.ProxySettings;
import com.crashlytics.api.ota.OrganizationPeopleJsonTransform;
import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseJsonTransform;
import com.crashlytics.api.ota.ReleaseNotes;
import com.crashlytics.api.ota.ReleaseNotesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class RestfulWebApi
implements WebApi {
    private static final String FATAL_TYPE = "fatal";
    private static final String NONFATAL_TYPE = "nonfatal";
    private static final String DEV_TOKEN = "ed8fc3dc68a7475cc970eb1e9c0cb6603b0a3ea2";
    private static final String USER_TAG = "User";
    private static final String ORGS_TAG = "Orgs";
    private static final String USER_TAG_OAUTH = "User-OAuth";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DISTRIBUTION_ANDROID_APP_TYPE = "android_app";
    private static final String DISTRIBUTION_SLICE_JAVA_ARCH = "java";
    private User _user = null;
    private List<App> _appsCache = null;
    private List<Organization> _orgsCache = null;
    private Map<App, List<Issue>> _issuesCache;
    private String _userAgent;
    private String _clientVersion = null;
    private String _clientType = null;
    private String _toolId = null;
    private String _toolVersion = null;
    private String _operatingSystem = null;
    private String _environmentId = null;
    private String _environmentVersion = null;
    private boolean _oauthEnabled = false;
    private OAuthClient _oauthClient = null;
    private OAuthClient.Token _oauthToken = null;
    private String _baseApiUrl;

    public String toString() {
        return " ClientType: " + this._clientType + " (" + this._clientVersion + ") ToolId: " + this._toolId + " (" + this._toolVersion + ") Operating System: " + this._operatingSystem + " Environment: " + this._environmentId + " (" + this._environmentVersion + ")";
    }

    private HttpResponse request(HttpRequestBase request) throws IOException, AuthenticationException {
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(request));
        request.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(request);
        RestfulWebApi.logRequest(request);
        HttpClient client = proxySettings.getClientFor();
        HttpResponse response = client.execute(request);
        if (this._oauthEnabled && RestfulWebApi.isUnauthorized(response.getStatusLine().getStatusCode())) {
            response = this.reauthenticateAndRetryViaOAuth(response, request, client);
        }
        RestfulWebApi.logResponse(response, response.getStatusLine().getStatusCode());
        return response;
    }

    public RestfulWebApi() {
        this("https://api.crashlytics.com");
    }

    public RestfulWebApi(String baseApiUrl) {
        this(baseApiUrl, false);
    }

    public RestfulWebApi(String baseApiUrl, boolean oauthEnabled) {
        JSONObject jsonUser;
        this._baseApiUrl = baseApiUrl;
        this._issuesCache = new HashMap<App, List<Issue>>();
        this._oauthEnabled = oauthEnabled;
        if (this._oauthEnabled) {
            try {
                this._oauthClient = new OAuthClient(new URI(baseApiUrl));
            }
            catch (URISyntaxException e) {
                DeveloperTools.logW("Crashlytics unexpectedly encountered a malformed URI.", e);
            }
        }
        if ((jsonUser = (JSONObject)RestfulWebApi.loadFromCache(this._oauthEnabled ? USER_TAG_OAUTH : USER_TAG)) != null) {
            this._user = this._oauthEnabled ? RestfulWebApi.updateUserCache(jsonUser, this._oauthToken, false) : RestfulWebApi.updateUserCache(jsonUser, false);
            this._orgsCache = RestfulWebApi.updateOrgsCache((JSONArray)RestfulWebApi.loadFromCache(ORGS_TAG), false);
        }
    }

    @Override
    public final synchronized void logout() {
        this._user = null;
        RestfulWebApi.deleteFileInCache(this._oauthEnabled ? USER_TAG_OAUTH : USER_TAG);
        RestfulWebApi.deleteFileInCache(ORGS_TAG);
        this._appsCache = null;
        this._orgsCache = null;
    }

    @Override
    public synchronized void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    @Override
    public synchronized void setClientType(String clientType) {
        this._clientType = clientType;
    }

    @Override
    public synchronized void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    @Override
    public final synchronized User authenticateUser(String email, String password) throws IOException {
        JSONObject response;
        this.logout();
        JSONObject jSONObject = response = this._oauthEnabled ? this.authenticateUserViaOAuth(email, password) : this.authenticateUserViaLegacy(email, password);
        if (response != null) {
            this._user = this._oauthEnabled ? RestfulWebApi.updateUserCache(response, this._oauthToken, true) : RestfulWebApi.updateUserCache(response, true);
            this._orgsCache = RestfulWebApi.updateOrgsCache((JSONArray)response.get("organizations"), true);
        }
        return this._user;
    }

    private static List<Organization> updateOrgsCache(JSONArray jsonOrgs, boolean flushToDisk) {
        LinkedList<Organization> cache = new LinkedList<Organization>();
        if (jsonOrgs != null) {
            if (flushToDisk) {
                RestfulWebApi.writeJSONToFile(ORGS_TAG, jsonOrgs);
            }
            for (Object element : jsonOrgs) {
                cache.add(new Organization((JSONObject)element));
            }
        }
        return cache;
    }

    private static User updateUserCache(JSONObject jsonUser, boolean flushToDisk) {
        if (flushToDisk) {
            RestfulWebApi.writeJSONToFile(USER_TAG, jsonUser);
        }
        String name = (String)jsonUser.get("name");
        String email = (String)jsonUser.get("email");
        String token = (String)jsonUser.get("token");
        return User.create(email, name, token);
    }

    private static User updateUserCache(JSONObject jsonUser, OAuthClient.Token token, boolean flushToDisk) {
        if (flushToDisk) {
            RestfulWebApi.writeJSONToFile(USER_TAG_OAUTH, jsonUser);
        }
        String name = (String)jsonUser.get("name");
        String email = null;
        JSONArray identities = (JSONArray)jsonUser.get("identities");
        for (Object identity : identities) {
            String service = (String)((JSONObject)identity).get("service");
            if (!service.equalsIgnoreCase("email")) continue;
            boolean primary = (Boolean)((JSONObject)identity).get("primary");
            boolean confirmed = (Boolean)((JSONObject)identity).get("confirmed");
            if (!primary || !confirmed) continue;
            email = (String)((JSONObject)identity).get("token");
            break;
        }
        return User.create(email, name, token);
    }

    private synchronized JSONObject authenticateUserViaLegacy(final String email, final String password) throws IOException {
        JSONObject request = new JSONObject(){
            {
                this.put("email", email);
                this.put("password", password);
            }
        };
        ByteArrayEntity entity = new ByteArrayEntity(request.toString().getBytes());
        entity.setContentType("application/json");
        HttpPost post = new HttpPost(this.getBaseApiUrl() + "/api/v2/session");
        post.setEntity(entity);
        try {
            return (JSONObject)this.requestJSON(post, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            return null;
        }
    }

    private synchronized JSONObject authenticateUserViaOAuth(String email, String password) throws IOException {
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(this._oauthClient.getBaseUrl().getPath()));
        HttpClient client = settings.getClientFor();
        this._oauthToken = this._oauthClient.getToken(client, email, password);
        if (this._oauthToken == null) {
            return null;
        }
        try {
            return (JSONObject)this.getJSON(new URI(this._baseApiUrl + "/api/v3/account"), Collections.<String, String>emptyMap());
        }
        catch (URISyntaxException e) {
            DeveloperTools.logW("Crashlytics encountered a bad URI", e);
        }
        catch (AuthenticationException e) {
            DeveloperTools.logE("Crashlytics couldn't fetch the account information", e);
        }
        return null;
    }

    private synchronized boolean reauthenticateUserViaOAuth() throws IOException {
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(this._oauthClient.getBaseUrl().getPath()));
        HttpClient client = settings.getClientFor();
        this._oauthToken = this._oauthClient.refreshToken(client, this._oauthToken);
        if (this._oauthToken != null) {
            this._user = User.create(this.getCurrentUser().getEmail(), this.getCurrentUser().getName(), this._oauthToken);
            return true;
        }
        return false;
    }

    private synchronized HttpResponse reauthenticateAndRetryViaOAuth(HttpResponse response, HttpRequestBase request, HttpClient client) throws AuthenticationException, IOException {
        int result;
        if (this.reauthenticateUserViaOAuth() && this._oauthToken != null) {
            response = client.execute(OAuthClient.sign(request, this._oauthToken));
        }
        if (RestfulWebApi.isUnauthorized(result = response.getStatusLine().getStatusCode())) {
            throw new AuthenticationException("Crashlytics Authentication failed [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        return response;
    }

    @Override
    public void asyncAuthenticate(final String email, final String password, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user;
                try {
                    user = RestfulWebApi.this.authenticateUser(email, password);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics User Authenticator").start();
    }

    @Override
    public final synchronized User authenticateWithToken(String token) throws IOException {
        URI uri;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("X-CRASHLYTICS-ACCESS-TOKEN", token);
        String uriStr = this.getBaseApiUrl() + "/api/v2/session";
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
            return null;
        }
        try {
            JSONObject response = (JSONObject)this.getJSON(uri, headerParams);
            if (response != null) {
                this._user = RestfulWebApi.updateUserCache(response, false);
            }
        }
        catch (AuthenticationException e) {
            DeveloperTools.logE("Unable to authenticate user.", e);
            return null;
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticateWithToken(final String token, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user;
                try {
                    user = RestfulWebApi.this.authenticateWithToken(token);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics Tokenized Authenticator").start();
    }

    @Override
    public synchronized List<Organization> getOrgs(boolean clearCache) throws IOException, AuthenticationException {
        URI uri;
        if (!clearCache && this._orgsCache != null) {
            return Collections.unmodifiableList(this._orgsCache);
        }
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving organizations.");
        }
        String uriStr = this.getBaseApiUrl() + "/api/v2/organizations";
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
            return null;
        }
        this._orgsCache = RestfulWebApi.updateOrgsCache((JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap()), true);
        return Collections.unmodifiableList(this._orgsCache);
    }

    @Override
    public void fetchApps(final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<App> apps;
                try {
                    apps = RestfulWebApi.this.getApps(true);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAppException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onRetrievedApps(RestfulWebApi.this, apps);
                }
            }
        }, "Crashlytics App Fetcher").start();
    }

    @Override
    public List<App> getApps(Organization org, boolean clearCache) throws IOException, AuthenticationException {
        List<App> allApps = this.getApps(clearCache);
        LinkedList<App> orgApps = new LinkedList<App>();
        for (App app : allApps) {
            if (!app.getOrganization().equals(org)) continue;
            orgApps.add(app);
        }
        return orgApps;
    }

    @Override
    public synchronized List<App> getApps(boolean clearCache) throws IOException, AuthenticationException {
        if (!clearCache && this._appsCache != null) {
            return Collections.unmodifiableList(this._appsCache);
        }
        this._appsCache = new LinkedList<App>();
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving apps.");
        }
        List<Organization> orgs = this.getOrgs(true);
        for (Organization org : orgs) {
            URI uri;
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + org.getId() + "/platforms/android/apps";
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
                return null;
            }
            JSONArray response = (JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap());
            if (response == null) continue;
            for (Object jsonApp : response) {
                App app = new App((JSONObject)jsonApp, org);
                if (!app.getPlatform().equalsIgnoreCase("android")) continue;
                this._appsCache.add(app);
            }
        }
        return Collections.unmodifiableList(this._appsCache);
    }

    @Override
    public synchronized List<Issue> getIssues(App app, boolean clearCache) throws IOException, AuthenticationException {
        LinkedList<Issue> allIssues = new LinkedList<Issue>();
        allIssues.addAll(this.getIssues(app, clearCache, FATAL_TYPE));
        allIssues.addAll(this.getIssues(app, clearCache, NONFATAL_TYPE));
        return allIssues;
    }

    private synchronized List<Issue> getIssues(App app, boolean clearCache, String issueType) throws IOException, AuthenticationException {
        if (clearCache) {
            this._issuesCache = new HashMap<App, List<Issue>>();
        }
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving issues.");
        }
        if (!this._issuesCache.containsKey(app)) {
            URI uri;
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + app.getOrganization().getId() + "/apps/" + app.getId() + "/issues?event_type_equals=" + issueType;
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
                return null;
            }
            JSONArray response = (JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap());
            LinkedList<Issue> issues = new LinkedList<Issue>();
            if (response != null) {
                DeveloperTools.logD("Issue RESPONSE:" + response.toJSONString());
                for (Object issue : response) {
                    try {
                        issues.add(new Issue((JSONObject)issue, app));
                    }
                    catch (Exception e) {
                        DeveloperTools.logE("Couldn't parse issue", e);
                    }
                }
            }
            DeveloperTools.logD("Issues:" + issues.size());
            this._issuesCache.put(app, issues);
        }
        return this._issuesCache.containsKey(app) ? Collections.unmodifiableList(this._issuesCache.get(app)) : Collections.emptyList();
    }

    @Override
    public boolean sendFile(URL url, File file, String mimeType, String fileParamName, Map<String, String> bodyParams) throws IOException {
        HttpPost httpPost;
        DeveloperTools.logD("POST file: " + file + " to URL: " + url);
        try {
            httpPost = new HttpPost(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ContentType mimeContentType = ContentType.create(mimeType);
        this.applyCommonHeadersTo(httpPost);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry<String, String> param : bodyParams.entrySet()) {
            builder.addPart(param.getKey(), new StringBody(param.getValue(), mimeContentType));
        }
        builder.addPart(fileParamName, new FileBody(file, mimeContentType));
        httpPost.setEntity(builder.build());
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = settings.getClientFor();
        httpPost.setConfig(settings.getConfig());
        HttpResponse response = client.execute(httpPost);
        int result = response.getStatusLine().getStatusCode();
        DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        return RestfulWebApi.isSuccess(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(URL url, File destination) throws IOException {
        HttpGet get;
        try {
            get = new HttpGet(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.applyCommonHeadersTo(get);
        get.addHeader("Accept", "application/octet-stream");
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = settings.getClientFor();
        get.setConfig(settings.getConfig());
        RestfulWebApi.logRequest(get);
        HttpResponse response = client.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        RestfulWebApi.logResponse(response, statusCode);
        if (statusCode == 200) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(destination);
                response.getEntity().writeTo(out);
                out.flush();
                boolean bl = true;
                return bl;
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        return false;
    }

    private void applyCommonHeadersTo(HttpRequestBase request) {
        request.addHeader("X-CRASHLYTICS-DEVELOPER-TOKEN", DEV_TOKEN);
        if (this._userAgent != null) {
            request.setHeader("User-Agent", this._userAgent);
        }
        if (this._clientType != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-TYPE", this._clientType);
        }
        if (this._clientVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-VERSION", this._clientVersion);
        }
        if (this._oauthEnabled) {
            if (this._oauthToken != null) {
                OAuthClient.sign(request, this._oauthToken);
            }
        } else if (this._user != null) {
            request.addHeader("X-CRASHLYTICS-ACCESS-TOKEN", (String)this._user.getToken().token);
        }
        if (this._toolId != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-ID", this._toolId);
        }
        if (this._toolVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-BUILD-VERSION", this._toolVersion);
            request.setHeader("X-CRASHLYTICS-API-CLIENT-DISPLAY-VERSION", this._toolVersion);
        }
        if (this._operatingSystem != null) {
            request.setHeader("X-CRASHLYTICS-API-OPERATING-SYSTEM", this._operatingSystem);
        }
        if (this._environmentVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-ENVIRONMENT-VERSION", this._environmentVersion);
        }
        if (this._environmentId != null) {
            request.setHeader("X-CRASHLYTICS-API-ENVIRONMENT-ID", this._environmentVersion);
        }
    }

    private JSONAware getJSON(URI uri, Map<String, String> headerParams) throws IOException, AuthenticationException {
        HttpGet get = new HttpGet(uri);
        return this.requestJSON(get, headerParams);
    }

    private JSONAware requestJSON(HttpRequestBase request, Map<String, String> headerParams) throws IOException, AuthenticationException {
        request.setHeader("Accept", "application/json");
        for (Map.Entry<String, String> header : headerParams.entrySet()) {
            request.addHeader(header.getKey(), header.getValue().trim());
        }
        HttpResponse response = this.request(request);
        Object json = RestfulWebApi.jsonFromResponse(response);
        RestfulWebApi.logResponse(response, response.getStatusLine().getStatusCode(), json);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends JSONAware> T jsonFromResponse(HttpResponse response) throws IOException {
        JSONAware jSONAware;
        if (!RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode())) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response.getEntity().getContent(), UTF_8);
            jSONAware = (JSONAware)JSONValue.parse(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return (T)jSONAware;
    }

    private static void logRequest(HttpRequestBase request) {
        DeveloperTools.logD("REQUEST: " + request.getURI());
    }

    private static void logResponse(HttpResponse response, int statusCodeResult, Object responseJSON) {
        DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]; " + responseJSON);
    }

    private static void logResponse(HttpResponse response, int statusCodeResult) {
        try {
            DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]");
        }
        catch (Exception e) {
            DeveloperTools.logE("Crashlytics experienced an error while logging a response.", e);
        }
    }

    @Override
    public Software getSoftwareIntegration(Organization org, String platform, String bundleId, String version) throws IOException {
        return this.getSoftwareIntegration(org.getApiKey(), platform, bundleId, version);
    }

    @Override
    public Software getSoftwareIntegration(String apiKey, String platform, String bundleId, String version) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + platform + "/integrations/" + bundleId + "?current_version=" + version);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = null;
        try {
            result = (JSONObject)this.getJSON(uri, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result == null ? null : Software.createFromJSON(result);
    }

    @Override
    public Software getAndroidSDK(Organization org, String currentVersion) throws IOException {
        return this.getAndroidSDK(org.getApiKey(), currentVersion);
    }

    @Override
    public Software getAndroidSDK(String apiKey, String currentVersion) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + "android" + "/sdks/com.crashlytics.android?current_version=" + currentVersion);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = null;
        try {
            result = (JSONObject)this.getJSON(uri, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result == null ? null : Software.createFromJSON(result);
    }

    @Override
    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    @Override
    public User getCurrentUser() {
        return this._user;
    }

    private static void writeJSONToFile(String tag, JSONObject json) {
        RestfulWebApi.writeJSONToFile(tag, json.toJSONString().getBytes(UTF_8));
    }

    private static void writeJSONToFile(String tag, JSONArray json) {
        RestfulWebApi.writeJSONToFile(tag, json.toJSONString().getBytes(UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJSONToFile(String tag, byte[] bytes) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not write " + file, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    DeveloperTools.logE("Could not close " + file, e);
                }
            }
        }
    }

    private static Object loadFromCache(String tag) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION);
        if (file.exists()) {
            try {
                String jsonString = FileUtils.fileToString(file);
                return JSONValue.parse(jsonString);
            }
            catch (IOException e) {
                DeveloperTools.logE("Could not read cache file " + file, e);
            }
        }
        return null;
    }

    private static boolean deleteFileInCache(String tag) {
        return new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION).delete();
    }

    private static String getRequestId(HttpResponse response) {
        Header requestIdHeader = response.getFirstHeader("X-Request-Id");
        return requestIdHeader == null ? "null" : requestIdHeader.getValue();
    }

    @Override
    public boolean createDistribution(String apiKey, String buildSecret, AppRelease appRelease, DistributionData distributionData, boolean sendNotifications, final WebApi.UploadProgressListener listener) throws AuthenticationException, IOException {
        HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("send_notifications", new StringBody(Boolean.toString(sendNotifications), ContentType.DEFAULT_TEXT)).addPart("distribution[file]", new FileBody(distributionData.distributionFile, ContentType.DEFAULT_BINARY, distributionData.distributionFile.getName())).addPart("distribution[built_at]", new StringBody(Long.toString(distributionData.builtAtSeconds), ContentType.DEFAULT_TEXT)).addPart("app[instance_identifier]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).addPart("app[display_version]", new StringBody(appRelease.displayVersion, ContentType.DEFAULT_TEXT)).addPart("app[build_version]", new StringBody(appRelease.buildVersion, ContentType.DEFAULT_TEXT)).addPart("app[type]", new StringBody(DISTRIBUTION_ANDROID_APP_TYPE, ContentType.DEFAULT_TEXT)).addPart("app[slices][][arch]", new StringBody(DISTRIBUTION_SLICE_JAVA_ARCH, ContentType.DEFAULT_TEXT)).addPart("app[slices][][uuid]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).build();
        final long contentLength = multipartEntity.getContentLength();
        ProgressReportingHttpEntity progressEntity = new ProgressReportingHttpEntity(multipartEntity, new ProgressReportingHttpEntity.ProgressListener(){

            @Override
            public void bytesWritten(long count) {
                listener.bytesWritten(contentLength, count);
            }
        });
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appRelease.packageName + "/distributions";
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "application/json");
        post.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        post.setHeader("X-CRASHLYTICS-BUILD-SECRET", buildSecret);
        post.setEntity(progressEntity);
        HttpResponse response = this.request(post);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public JSONObject inviteTester(String apiKey, String appPackageName, String email, String name) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("email", email));
        nameValuePairs.add(new BasicNameValuePair("name", name));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/invitations";
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "application/json");
        post.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        post.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(post);
        return (JSONObject)RestfulWebApi.jsonFromResponse(response);
    }

    @Override
    public ReleaseNotes getReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Object json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseNotesJsonTransform().createReleaseNotesFrom((JSONObject)json);
    }

    @Override
    public boolean setReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, ReleaseNotes releaseNotes) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("release_notes[format]", releaseNotes.getFormat().name().toLowerCase()));
        nameValuePairs.add(new BasicNameValuePair("release_notes[body]", releaseNotes.getBody()));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes";
        HttpPut put = new HttpPut(url);
        put.setHeader("Accept", "application/json");
        put.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(put);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public Release getRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("include_disabled", "true"));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/summary?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Object json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseJsonTransform().createReleaseFrom((JSONObject)json);
    }

    @Override
    public List<ReleaseSummary> getReleaseSummaries(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases_by_display_versions";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Object json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseSummariesJsonTransform().createReleaseSummariesFrom((JSONObject)json);
    }

    @Override
    public Release getAccessToRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/access?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Object json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseJsonTransform().createAccessReleaseFrom((JSONObject)json);
    }

    @Override
    public boolean updateAccess(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, List<String> testerIds, List<String> groupIds, WebApi.AccessChange accessChange, boolean sendNotifications) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("send_notifications", Boolean.toString(sendNotifications)));
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        for (String testerId : testerIds) {
            nameValuePairs.add(new BasicNameValuePair("tester_ids[]", testerId));
        }
        for (String groupId : groupIds) {
            nameValuePairs.add(new BasicNameValuePair("group_ids[]", groupId));
        }
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/access/" + accessChange.getPathComponent();
        HttpPut put = new HttpPut(url);
        put.setHeader("Accept", "application/json");
        put.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(put);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public List<Person> getPeopleInOrganization(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/testers_in_organization";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Object json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new OrganizationPeopleJsonTransform().createPeopleFrom((JSONObject)json);
    }

    private static boolean isSuccess(int resultCode) {
        return resultCode >= 200 && resultCode < 300;
    }

    private static boolean isUnauthorized(int resultCode) {
        return resultCode == 401 || resultCode == 403;
    }

    @Override
    public void asyncNotifyBuildEvent(final String appPackageName, final String instanceId, final String orgId, final String buildSecretOrNull, final String extraDetailsOrNull) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RestfulWebApi.this.notifyBuildEvent(appPackageName, instanceId, orgId, buildSecretOrNull, extraDetailsOrNull);
            }
        }, "Build Event Notification").start();
    }

    public void notifyBuildEvent(String appPackageName, String instanceId, String orgId, String buildSecretOrNull, String extraDetailsOrNull) {
        DeveloperTools.logD("Build Event: " + appPackageName + " ID:" + instanceId + " ApiKey:" + orgId + " Tool:" + this._toolId + " " + this._toolVersion + " Extra Details:" + extraDetailsOrNull + " API Secret Null? " + (buildSecretOrNull == null));
        try {
            String url = this.getBaseApiUrl() + "/spi/v1/platforms/android/apps/" + appPackageName + "/built";
            ContentType mimeContentType = ContentType.create("text/plain");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("X-CRASHLYTICS-API-KEY", orgId);
            if (buildSecretOrNull != null) {
                httpPost.setHeader("X-CRASHLYTICS-BUILD-SECRET", buildSecretOrNull);
            }
            this.applyCommonHeadersTo(httpPost);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("app_name", new StringBody(appPackageName, mimeContentType));
            httpPost.setEntity(builder.build());
            if (extraDetailsOrNull != null) {
                builder.addPart("tool_detail", new StringBody(extraDetailsOrNull, mimeContentType));
            }
            ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(httpPost));
            HttpClient client = settings.getClientFor();
            httpPost.setConfig(settings.getConfig());
            RestfulWebApi.logRequest(httpPost);
            HttpResponse response = client.execute(httpPost);
            int result = response.getStatusLine().getStatusCode();
            DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        catch (IOException e) {
            DeveloperTools.logD("Crashlytics was unable to notify of build event. " + e.getClass() + ": " + e.getMessage());
        }
    }

    @Override
    public void setToolId(String toolId) {
        this._toolId = toolId;
    }

    @Override
    public void setToolVersion(String toolVersion) {
        this._toolVersion = toolVersion;
    }

    @Override
    public void setOperatingSystem(String os) {
        this._operatingSystem = os;
    }

    @Override
    public void setEnvironmentId(String environmentId) {
        this._environmentId = environmentId;
    }

    @Override
    public void setEnvironmentVersion(String environmentVersion) {
        this._environmentVersion = environmentVersion;
    }

    @Override
    public App getApp(String bundleId, boolean clearCache) throws IOException, AuthenticationException {
        if (bundleId != null) {
            for (App app : this.getApps(clearCache)) {
                if (!app.bundleIdEquals(bundleId)) continue;
                return app;
            }
        }
        return null;
    }

    @Override
    public Organization getOrg(String apiKey) throws IOException, AuthenticationException {
        if (apiKey != null) {
            for (Organization org : this.getOrgs(false)) {
                if (!apiKey.equals(org.getApiKey())) continue;
                return org;
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getEnrollments(Organization org) throws IOException, AuthenticationException {
        String url = this._baseApiUrl + "/api/v2/organizations/" + org.getId() + "/enrollments";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        JSONObject responseJson = (JSONObject)RestfulWebApi.jsonFromResponse(this.request(get));
        return new EnrollmentsJsonTransform().createEnrollmentsFrom((JSONObject)responseJson.get("enrollments"));
    }
}

