/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.PersonGroup;
import com.crashlytics.api.ota.PersonGroupJsonTransform;
import com.crashlytics.api.ota.PersonJsonTransform;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ReleaseJsonTransform {
    private static final String SUMMARY = "summary";
    private static final String AUTHORIZED_DEVICES = "authorized_devices";
    private static final String ENTRIES = "entries";
    private static final String GROUPS = "groups";
    private final ReleaseSummariesJsonTransform _releaseSummaryTransform = new ReleaseSummariesJsonTransform();
    private final PersonJsonTransform _personTransform = new PersonJsonTransform();
    private final PersonGroupJsonTransform _groupTransform = new PersonGroupJsonTransform();

    public Release createReleaseFrom(JSONObject releaseJson) {
        if (releaseJson == null) {
            return null;
        }
        JSONObject summaryJson = (JSONObject)releaseJson.get(SUMMARY);
        ReleaseSummary summary = this._releaseSummaryTransform.createSingleReleaseSummaryFrom(summaryJson);
        JSONArray authDevicesJson = (JSONArray)releaseJson.get(AUTHORIZED_DEVICES);
        ArrayList authorizedDevices = authDevicesJson == null ? new ArrayList() : authDevicesJson;
        List<Person> people = this.createPeopleFrom(releaseJson);
        return new Release(summary, authorizedDevices, people, Collections.<PersonGroup>emptyList());
    }

    public Release createAccessReleaseFrom(JSONObject releaseJson) {
        if (releaseJson == null) {
            return null;
        }
        JSONObject summaryJson = (JSONObject)releaseJson.get(SUMMARY);
        ReleaseSummary summary = this._releaseSummaryTransform.createAccessReleaseSummaryFrom(summaryJson);
        List<Person> people = this.createPeopleFrom(releaseJson);
        List<PersonGroup> groups = this.createGroupsForReleaseFrom(releaseJson);
        return new Release(summary, Collections.<String>emptyList(), people, groups);
    }

    private List<Person> createPeopleFrom(JSONObject releaseJson) {
        ArrayList<Person> people = new ArrayList<Person>();
        JSONArray peopleJson = (JSONArray)releaseJson.get(ENTRIES);
        if (peopleJson != null) {
            for (Object personObj : peopleJson) {
                JSONObject personJson = (JSONObject)personObj;
                people.add(this._personTransform.createPersonFrom(personJson));
            }
        }
        return people;
    }

    private List<PersonGroup> createGroupsForReleaseFrom(JSONObject releaseJson) {
        ArrayList<PersonGroup> groups = new ArrayList<PersonGroup>();
        JSONArray groupsJson = (JSONArray)releaseJson.get(GROUPS);
        if (groupsJson != null) {
            for (Object groupObj : groupsJson) {
                groups.add(this._groupTransform.createGroupForReleaseFrom((JSONObject)groupObj));
            }
        }
        return groups;
    }
}

