/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.FileCode;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ManifestProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ManifestFileProvider
implements ManifestProvider {
    private final File _manifestFile;

    public ManifestFileProvider(File manifestFile) {
        this._manifestFile = manifestFile;
    }

    @Override
    public InputStream getManifestStream() throws ManifestData.ManifestIOException {
        try {
            return new BufferedInputStream(new FileInputStream(this._manifestFile));
        }
        catch (FileNotFoundException e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not find the manifest. Not found at " + this._manifestFile.getAbsolutePath());
        }
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public Code getManifestCode() throws ManifestData.ManifestIOException {
        return new FileCode(this.getManifestFile());
    }

    @Override
    public String getManifestString() throws ManifestData.ManifestIOException {
        try {
            return FileUtils.readFileToString(this._manifestFile);
        }
        catch (IOException e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not read the manifest at" + this._manifestFile.getAbsolutePath());
        }
    }

    @Override
    public ManifestData getManifestData() throws ManifestData.ManifestIOException {
        return DefaultManifestData.createManifest(this);
    }
}

