/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.api.AppRelease;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class ApkUtils {
    private static final String TAG = "[ApkUtils] ";
    public static final boolean DEBUG_LOGGING = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AppRelease readBuildPropertiesFromApk(File apkFile) {
        ZipInputStream zin = null;
        Properties buildProperties = new Properties();
        try {
            ZipEntry ze;
            zin = new ZipInputStream(new FileInputStream(apkFile));
            while ((ze = zin.getNextEntry()) != null) {
                String name;
                if (ze.isDirectory() || !"assets/crashlytics-build.properties".equals(name = ze.getName())) continue;
                buildProperties.load(zin);
                break;
            }
        }
        catch (Exception e) {
            try {
                ApkUtils.logE("Crashlytics could not find assets/crashlytics-build.properties in the APK.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zin);
                throw throwable;
            }
            IOUtils.closeQuietly(zin);
        }
        IOUtils.closeQuietly(zin);
        if (!buildProperties.isEmpty()) {
            String appName = buildProperties.getProperty("app_name");
            String packageName = buildProperties.getProperty("package_name");
            String instanceId = buildProperties.getProperty("build_id");
            String displayVersion = buildProperties.getProperty("version_name");
            String buildVersion = buildProperties.getProperty("version_code");
            return new AppRelease(appName, packageName, instanceId, displayVersion, buildVersion);
        }
        return null;
    }

    public static void log(String s) {
    }

    public static void logW(String s, Throwable t) {
        DeveloperTools.logW(TAG + s, t);
    }

    public static void logE(String s, Throwable t) {
        DeveloperTools.logE(TAG + s, t);
    }
}

