/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class PropertiesUtils {
    public static final String OPT_HELP = "help";
    public static final String OPT_PROPERTIES_PATH = "properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties read(File propertiesFile) throws IOException {
        Properties propertiesFromDisk = new Properties();
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), "UTF-8");
            propertiesFromDisk.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return propertiesFromDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File propertiesFile, Properties props, String comment) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            props.store(out, comment);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
    }

    public static void injectPropertyInFile(File propertiesFile, Properties propertiesToUpdate, String header) throws IOException {
        Properties props = null;
        try {
            props = PropertiesUtils.read(propertiesFile);
        }
        catch (IOException io) {
            // empty catch block
        }
        if (props == null) {
            propertiesFile.delete();
            propertiesFile.createNewFile();
            props = new Properties();
        }
        boolean changedAny = false;
        for (Map.Entry<Object, Object> e : propertiesToUpdate.entrySet()) {
            if (props.containsKey(e.getKey()) && e.getValue().equals(props.get(e.getKey()))) continue;
            props.put(e.getKey(), e.getValue());
            changedAny = true;
        }
        if (changedAny) {
            PropertiesUtils.write(propertiesFile, props, header);
        }
    }

    public static Properties processArgs(String mainClassName, String[] args, Options options) throws Exception {
        Properties properties = null;
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(OPT_HELP)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(mainClassName, options);
            } else {
                properties = PropertiesUtils.getProperties(line);
            }
            return properties;
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(mainClassName, options);
            throw e;
        }
    }

    private static Properties getProperties(CommandLine line) throws Exception {
        Properties propertiesFromDisk = new Properties();
        File propertiesFile = null;
        if (line.hasOption(OPT_PROPERTIES_PATH)) {
            propertiesFile = new File(line.getOptionValue(OPT_PROPERTIES_PATH));
            try {
                propertiesFromDisk = PropertiesUtils.read(propertiesFile);
            }
            catch (IOException io) {
                propertiesFromDisk = new Properties();
            }
        }
        Properties optionsProperties = new Properties();
        for (Option opt : line.getOptions()) {
            if (opt.getValue() != null) {
                optionsProperties.put(opt.getOpt(), opt.getValue());
                continue;
            }
            optionsProperties.put(opt.getOpt(), "true");
        }
        propertiesFromDisk.putAll((Map<?, ?>)optionsProperties);
        return propertiesFromDisk;
    }

    public static String toString(Properties properties) {
        StringBuilder argsStr = new StringBuilder();
        for (Map.Entry<Object, Object> argEntry : properties.entrySet()) {
            argsStr.append("\n-" + argEntry.getKey() + " " + argEntry.getValue());
        }
        return argsStr.toString();
    }
}

