/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@org.apache.maven.plugins.annotations.Mojo(name="CleanupResources", defaultPhase=LifecyclePhase.PACKAGE)
public class CrashlyticsCleanupResourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue=".")
    private String projectPath;
    @Parameter(defaultValue="target/proguard/mapping.txt", alias="mapping_location")
    private String mappingFilePath;
    @Parameter(defaultValue="res")
    private String androidResPath;
    @Parameter(defaultValue="AndroidManifest.xml")
    private String androidManifestPath;
    @Parameter(defaultValue="false", alias="force_mapping_upload")
    private String forceMappingUpload;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Crashlytics - CleanupResources");
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("mappingFilePath: " + this.mappingFilePath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("forceMappingUpload: " + this.forceMappingUpload));
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        if (Boolean.parseBoolean(this.forceMappingUpload) || this.isProGuardEnabled()) {
            DeveloperToolsUtils.storeDeobsFile(this.projectPath, this.mappingFilePath, this.androidResPath, this.androidManifestPath);
        }
        DeveloperToolsUtils.cleanupResourceFile(this.projectPath, this.androidResPath, this.androidManifestPath);
        DeveloperToolsUtils.uploadDeobsFiles(this.projectPath, this.androidResPath, this.androidManifestPath);
    }

    private boolean isProGuardEnabled() {
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        boolean skipped = true;
        for (Object obj : project.getBuildPlugins()) {
            Xpp3Dom skipDom;
            Xpp3Dom proguardDom;
            Plugin plugin = (Plugin)obj;
            if (!"android-maven-plugin".equals(plugin.getArtifactId())) continue;
            Xpp3Dom dom = (Xpp3Dom)plugin.getConfiguration();
            if (dom == null || (proguardDom = dom.getChild("proguard")) == null || (skipDom = proguardDom.getChild("skip")) == null) break;
            skipped = Boolean.parseBoolean(skipDom.getValue());
            break;
        }
        this.getLog().debug((CharSequence)("ProGuard skip = " + skipped));
        return !skipped;
    }
}

