/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@org.apache.maven.plugins.annotations.Mojo(name="CleanupResources", defaultPhase=LifecyclePhase.PACKAGE)
public class CrashlyticsCleanupResourcesMojo
extends AbstractCrashlyticsMojo {
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidManifestPath;
    @Parameter(defaultValue="target/proguard/mapping.txt", alias="mapping_location")
    private String mappingFilePath;
    @Parameter(defaultValue="false", alias="force_mapping_upload")
    private String forceMappingUpload;
    @Parameter(defaultValue="false", alias="require_upload_success")
    private String requireUploadSuccess;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Crashlytics - CleanupResources");
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("mappingFilePath: " + this.mappingFilePath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("forceMappingUpload: " + this.forceMappingUpload));
        this.getLog().debug((CharSequence)("requireUploadSuccess: " + this.requireUploadSuccess));
        if (this.projectPath == null) {
            this.projectPath = this.getDefaultProjectPath();
            this.getLog().debug((CharSequence)("projectPath set to Maven project basedir: " + this.projectPath));
        }
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        if (Boolean.parseBoolean(this.forceMappingUpload) || this.isProGuardEnabled(this.getMavenProject())) {
            String mappingFile = this.projectPath + "/" + this.mappingFilePath;
            DeveloperToolsUtils.storeDeobsFile(this.projectPath, this.androidResPath, this.androidManifestPath, mappingFile);
        }
        DeveloperToolsUtils.cleanupResourceFile(this.projectPath, this.androidResPath, this.androidManifestPath);
        DeveloperToolsUtils.uploadDeobsFiles(this.projectPath, this.androidResPath, this.androidManifestPath, this.requireUploadSuccess);
    }

    private boolean isProGuardEnabled(MavenProject project) {
        boolean skipped = true;
        for (Object obj : project.getBuildPlugins()) {
            Xpp3Dom skipDom;
            Xpp3Dom proguardDom;
            Plugin plugin = (Plugin)obj;
            if (!"android-maven-plugin".equals(plugin.getArtifactId())) continue;
            Xpp3Dom dom = (Xpp3Dom)plugin.getConfiguration();
            if (dom == null || (proguardDom = dom.getChild("proguard")) == null || (skipDom = proguardDom.getChild("skip")) == null) break;
            skipped = Boolean.parseBoolean(skipDom.getValue());
            break;
        }
        this.getLog().debug((CharSequence)("ProGuard skip = " + skipped));
        return !skipped;
    }
}

