/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.tools.android.DeveloperTools;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeveloperToolsUtils {
    DeveloperToolsUtils() {
    }

    public static void storeDeobsFile(String projectPath, String androidResPath, String androidManifestPath, String mappingFilePath) {
        ArrayList<String> args = new ArrayList<String>();
        DeveloperToolsUtils.appendOptionalArgTo(args, "-projectPath", projectPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidRes", androidResPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidManifest", androidManifestPath);
        DeveloperToolsUtils.appendValueArgTo(args, "-storeDeobs", mappingFilePath);
        DeveloperToolsUtils.appendValueArgTo(args, "-obfuscator", "proguard");
        DeveloperToolsUtils.appendValueArgTo(args, "-obVer", "4.7");
        DeveloperTools.processArgsSafe((String[])args.toArray(new String[args.size()]));
    }

    public static void cleanupResourceFile(String projectPath, String androidResPath, String androidManifestPath) {
        ArrayList<String> args = new ArrayList<String>();
        DeveloperToolsUtils.appendOptionalArgTo(args, "-projectPath", projectPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidRes", androidResPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidManifest", androidManifestPath);
        DeveloperToolsUtils.appendArgTo(args, "-cleanupResourceFile");
        DeveloperTools.processArgsSafe((String[])args.toArray(new String[args.size()]));
    }

    public static void uploadDeobsFiles(String projectPath, String androidResPath, String androidManifestPath, String requireUploadSuccess) {
        ArrayList<String> args = new ArrayList<String>();
        DeveloperToolsUtils.appendOptionalArgTo(args, "-projectPath", projectPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidRes", androidResPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidManifest", androidManifestPath);
        if (Boolean.valueOf(requireUploadSuccess).booleanValue()) {
            DeveloperToolsUtils.appendArgTo(args, "-requireUploadSuccess");
        }
        DeveloperToolsUtils.appendArgTo(args, "-uploadDeobs");
        DeveloperTools.processArgsSafe((String[])args.toArray(new String[args.size()]));
    }

    public static void generateResourceFile(String projectPath, String androidResPath, String androidManifestPath) {
        ArrayList<String> args = new ArrayList<String>();
        DeveloperToolsUtils.appendOptionalArgTo(args, "-projectPath", projectPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidRes", androidResPath);
        DeveloperToolsUtils.appendOptionalArgTo(args, "-androidManifest", androidManifestPath);
        DeveloperToolsUtils.appendArgTo(args, "-generateResourceFile");
        DeveloperTools.processArgsSafe((String[])args.toArray(new String[args.size()]));
    }

    private static void appendOptionalArgTo(List<String> args, String paramName, String paramValue) {
        if (paramValue != null) {
            args.add(paramName);
            args.add(paramValue);
        }
    }

    private static void appendValueArgTo(List<String> args, String paramName, String paramValue) {
        args.add(paramName);
        args.add(paramValue);
    }

    private static void appendArgTo(List<String> args, String paramName) {
        args.add(paramName);
    }
}

