/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.operations;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemManager;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.operations.FileOperation;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.operations.FileOperationProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.operations.FileOperations;
import java.util.ArrayList;

public class DefaultFileOperations
implements FileOperations {
    private FileSystemManager fsmanager;
    private FileObject fileObject;

    public DefaultFileOperations(FileObject file) {
        this.fileObject = file;
        this.fsmanager = file.getFileSystem().getFileSystemManager();
    }

    public Class[] getOperations() throws FileSystemException {
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            return null;
        }
        ArrayList operations = new ArrayList();
        for (int i = 0; i < providers.length; ++i) {
            FileOperationProvider provider = providers[i];
            provider.collectOperations(operations, this.fileObject);
        }
        return operations.toArray(new Class[0]);
    }

    public FileOperation getOperation(Class operationClass) throws FileSystemException {
        FileOperationProvider provider;
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", operationClass);
        }
        FileOperation resultOperation = null;
        for (int i = 0; i < providers.length && (resultOperation = (provider = providers[i]).getOperation(this.fileObject, operationClass)) == null; ++i) {
        }
        if (resultOperation == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", operationClass);
        }
        return resultOperation;
    }

    public boolean hasOperation(Class operationClass) throws FileSystemException {
        Class[] operations = this.getOperations();
        if (operations == null) {
            return false;
        }
        for (int i = 0; i < operations.length; ++i) {
            Class operation = operations[i];
            if (!operationClass.isAssignableFrom(operation)) continue;
            return true;
        }
        return false;
    }
}

