/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Sets;
import com.crashlytics.tools.android.onboard.KitClass;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.utils.GradleUtils;
import java.util.Set;

public class Kit {
    private final String _id;
    private final String _groupId;
    private final String _artifactId;
    private final String _version;
    private final String _prettyName;
    private final String _description;
    private final KitClass _kitClass;
    private final Set<Feature> _features;
    private final boolean _isAar;
    private final boolean _hasProguardConfiguration;
    private final Optional<String> _args;
    private final Optional<String> _imagePath;
    private final Optional<String> _learnMoreUrl;
    private final Optional<String> _extendedDescription;

    public static Kit createLegacyKit(String id, String groupId, String artifactId, String version, KitClass kitClass, String prettyName) {
        return new Kit(id, groupId, artifactId, version, prettyName, null, kitClass, Feature.featureless(), Optional.<String>absent(), Optional.<String>absent(), Optional.<String>absent(), Optional.<String>absent(), false, false);
    }

    public Kit(String id, String groupId, String artifactId, String version, String prettyName, String description, KitClass kitClass, Set<Feature> features, Optional<String> args, Optional<String> imagePath, Optional<String> learnMoreUrl, Optional<String> extendedDescription, boolean isAar, boolean hasProguardConfiguration) {
        this._id = id;
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._version = version;
        this._prettyName = prettyName;
        this._description = description;
        this._kitClass = kitClass;
        this._features = features;
        this._args = args;
        this._imagePath = imagePath;
        this._learnMoreUrl = learnMoreUrl;
        this._extendedDescription = extendedDescription;
        this._isAar = isAar;
        this._hasProguardConfiguration = hasProguardConfiguration;
    }

    public String getBackendIdentifier() {
        return this._id;
    }

    public String getPackageName() {
        return this._groupId + "." + this._artifactId;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getVersion() {
        return this._version;
    }

    public String getPrettyName() {
        return this._prettyName;
    }

    public String getDescription() {
        return this._description;
    }

    public String getArgs() {
        if (this._args.isPresent()) {
            return this._args.get();
        }
        return "";
    }

    public Optional<String> getImagePath() {
        return this._imagePath;
    }

    public Optional<String> getLearnMoreUrl() {
        return this._learnMoreUrl;
    }

    public Optional<String> getExtendedDescription() {
        return this._extendedDescription;
    }

    public KitClass getKitClass() {
        return this._kitClass;
    }

    public Set<Feature> getFeatures() {
        return this._features;
    }

    public String getGradleDependencyString(String lineSeparator) {
        return Kit.wrap(this.getBareGradleDependencyString(), lineSeparator, this._isAar);
    }

    private static String wrap(String bareGradleDependencyString, String lineSeparator, boolean isAar) {
        return !isAar ? "compile '" + bareGradleDependencyString + "'" : "compile('" + bareGradleDependencyString + "') {" + lineSeparator + GradleUtils.getTabs(1) + "transitive = true;" + lineSeparator + "}";
    }

    public String getBareGradleDependencyString() {
        return this._groupId + ":" + this._artifactId + ":" + this._version + (this._isAar ? "@aar" : "");
    }

    public boolean isSameArtifact(Kit other) {
        return this.getArtifactId().equals(other.getArtifactId()) && this.getGroupId().equals(other.getGroupId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Kit)) {
            return false;
        }
        Kit kit = (Kit)o;
        return this._artifactId.equals(kit._artifactId) && this._groupId.equals(kit._groupId) && this._version.equals(kit._version);
    }

    public int hashCode() {
        int result = this._groupId.hashCode();
        result = 31 * result + this._artifactId.hashCode();
        result = 31 * result + this._version.hashCode();
        return result;
    }

    public static Optional<Kit> fromIdentifier(String identifier) {
        for (Kit kit : OnboardingConstants.DEFAULT_KITS) {
            if (!identifier.equals(kit.getBackendIdentifier())) continue;
            return Optional.of(kit);
        }
        return Optional.absent();
    }

    public boolean hasProguardConfiguration() {
        return this._hasProguardConfiguration;
    }

    public static class Feature<T> {
        public final T context;

        public Feature(T context) {
            this.context = context;
        }

        public static Set<Feature> featureless() {
            return Sets.newHashSet();
        }
    }
}

