/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.util;

import com.crashlytics.dependency.reloc.org.apache.commons.logging.Log;
import com.crashlytics.dependency.reloc.org.apache.commons.logging.LogFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemManager;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.Messages;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DelegatingFileSystemOptionsBuilder {
    private Log log = LogFactory.getLog(class$org$apache$commons$vfs$util$DelegatingFileSystemOptionsBuilder == null ? (class$org$apache$commons$vfs$util$DelegatingFileSystemOptionsBuilder = DelegatingFileSystemOptionsBuilder.class$("com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.DelegatingFileSystemOptionsBuilder")) : class$org$apache$commons$vfs$util$DelegatingFileSystemOptionsBuilder);
    private static final Class[] STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DelegatingFileSystemOptionsBuilder.class$("java.lang.String")) : class$java$lang$String};
    private final FileSystemManager manager;
    private final Map beanMethods = new TreeMap();
    private static final Map primitiveToObject = new TreeMap();
    static /* synthetic */ Class class$org$apache$commons$vfs$util$DelegatingFileSystemOptionsBuilder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$apache$commons$vfs$FileSystemOptions;

    public DelegatingFileSystemOptionsBuilder(FileSystemManager manager) {
        this.manager = manager;
    }

    protected FileSystemManager getManager() {
        return this.manager;
    }

    public void setConfigString(FileSystemOptions fso, String scheme, String name, String value) throws FileSystemException {
        this.setConfigStrings(fso, scheme, name, new String[]{value});
    }

    public void setConfigStrings(FileSystemOptions fso, String scheme, String name, String[] values) throws FileSystemException {
        Context ctx = new Context(fso, scheme, name, values);
        this.setValues(ctx);
    }

    public void setConfigClass(FileSystemOptions fso, String scheme, String name, Class className) throws FileSystemException, IllegalAccessException, InstantiationException {
        this.setConfigClasses(fso, scheme, name, new Class[]{className});
    }

    public void setConfigClasses(FileSystemOptions fso, String scheme, String name, Class[] classNames) throws FileSystemException, IllegalAccessException, InstantiationException {
        Object[] values = new Object[classNames.length];
        for (int iterClassNames = 0; iterClassNames < values.length; ++iterClassNames) {
            values[iterClassNames] = classNames[iterClassNames].newInstance();
        }
        Context ctx = new Context(fso, scheme, name, values);
        this.setValues(ctx);
    }

    private void setValues(Context ctx) throws FileSystemException {
        if (!this.fillConfigSetters(ctx)) {
            throw new FileSystemException("vfs.provider/config-key-invalid.error", new String[]{ctx.scheme, ctx.name});
        }
        ctx.fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(ctx.scheme);
        Iterator iterConfigSetters = ctx.configSetters.iterator();
        while (iterConfigSetters.hasNext()) {
            Method configSetter = (Method)iterConfigSetters.next();
            if (!this.convertValuesAndInvoke(configSetter, ctx)) continue;
            return;
        }
        throw new FileSystemException("vfs.provider/config-value-invalid.error", new Object[]{ctx.scheme, ctx.name, ctx.values});
    }

    private boolean convertValuesAndInvoke(Method configSetter, Context ctx) throws FileSystemException {
        Method valueFactory;
        Constructor valueConstructor;
        Class<?> valueClass;
        Class type;
        Class<?>[] parameters = configSetter.getParameterTypes();
        if (parameters.length < 2) {
            return false;
        }
        if (!parameters[0].isAssignableFrom(class$org$apache$commons$vfs$FileSystemOptions == null ? (class$org$apache$commons$vfs$FileSystemOptions = DelegatingFileSystemOptionsBuilder.class$("com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions")) : class$org$apache$commons$vfs$FileSystemOptions)) {
            return false;
        }
        Class<?> valueParameter = parameters[1];
        if (valueParameter.isArray()) {
            type = valueParameter.getComponentType();
        } else {
            if (ctx.values.length > 1) {
                return false;
            }
            type = valueParameter;
        }
        if (type.isPrimitive()) {
            Class objectType = (Class)primitiveToObject.get(type.getName());
            if (objectType == null) {
                this.log.warn(Messages.getString("vfs.provider/config-unexpected-primitive.error", type.getName()));
                return false;
            }
            type = objectType;
        }
        if (type.isAssignableFrom(valueClass = ctx.values[0].getClass())) {
            this.invokeSetter(valueParameter, ctx, configSetter, ctx.values);
            return true;
        }
        if (valueClass != (class$java$lang$String == null ? (class$java$lang$String = DelegatingFileSystemOptionsBuilder.class$("java.lang.String")) : class$java$lang$String)) {
            this.log.warn(Messages.getString("vfs.provider/config-unexpected-value-class.error", new String[]{valueClass.getName(), ctx.scheme, ctx.name}));
            return false;
        }
        Object convertedValues = Array.newInstance(type, ctx.values.length);
        try {
            valueConstructor = type.getConstructor(STRING_PARAM);
        }
        catch (NoSuchMethodException e) {
            valueConstructor = null;
        }
        if (valueConstructor != null) {
            for (int iterValues = 0; iterValues < ctx.values.length; ++iterValues) {
                try {
                    Array.set(convertedValues, iterValues, valueConstructor.newInstance(ctx.values[iterValues]));
                    continue;
                }
                catch (InstantiationException e) {
                    throw new FileSystemException(e);
                }
                catch (IllegalAccessException e) {
                    throw new FileSystemException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FileSystemException(e);
                }
            }
            this.invokeSetter(valueParameter, ctx, configSetter, convertedValues);
            return true;
        }
        try {
            valueFactory = type.getMethod("valueOf", STRING_PARAM);
            if (!Modifier.isStatic(valueFactory.getModifiers())) {
                valueFactory = null;
            }
        }
        catch (NoSuchMethodException e) {
            valueFactory = null;
        }
        if (valueFactory != null) {
            for (int iterValues = 0; iterValues < ctx.values.length; ++iterValues) {
                try {
                    Array.set(convertedValues, iterValues, valueFactory.invoke(null, ctx.values[iterValues]));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new FileSystemException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FileSystemException(e);
                }
            }
            this.invokeSetter(valueParameter, ctx, configSetter, convertedValues);
            return true;
        }
        return false;
    }

    private void invokeSetter(Class valueParameter, Context ctx, Method configSetter, Object values) throws FileSystemException {
        Object[] args = valueParameter.isArray() ? new Object[]{ctx.fso, values} : new Object[]{ctx.fso, Array.get(values, 0)};
        try {
            configSetter.invoke((Object)ctx.fileSystemConfigBuilder, args);
        }
        catch (IllegalAccessException e) {
            throw new FileSystemException(e);
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException(e);
        }
    }

    private boolean fillConfigSetters(Context ctx) throws FileSystemException {
        Map schemeMethods = this.getSchemeMethods(ctx.scheme);
        List configSetters = (List)schemeMethods.get(ctx.name.toLowerCase());
        if (configSetters == null) {
            return false;
        }
        ctx.configSetters = configSetters;
        return true;
    }

    private Map getSchemeMethods(String scheme) throws FileSystemException {
        Map schemeMethods = (Map)this.beanMethods.get(scheme);
        if (schemeMethods == null) {
            schemeMethods = this.createSchemeMethods(scheme);
            this.beanMethods.put(scheme, schemeMethods);
        }
        return schemeMethods;
    }

    private Map createSchemeMethods(String scheme) throws FileSystemException {
        FileSystemConfigBuilder fscb = this.getManager().getFileSystemConfigBuilder(scheme);
        if (fscb == null) {
            throw new FileSystemException("vfs.provider/no-config-builder.error", scheme);
        }
        TreeMap<String, ArrayList<Method>> schemeMethods = new TreeMap<String, ArrayList<Method>>();
        Method[] methods = fscb.getClass().getMethods();
        for (int iterMethods = 0; iterMethods < methods.length; ++iterMethods) {
            String methodName;
            Method method = methods[iterMethods];
            if (!Modifier.isPublic(method.getModifiers()) || !(methodName = method.getName()).startsWith("set")) continue;
            String key = methodName.substring(3).toLowerCase();
            ArrayList<Method> configSetter = (ArrayList<Method>)schemeMethods.get(key);
            if (configSetter == null) {
                configSetter = new ArrayList<Method>(2);
                schemeMethods.put(key, configSetter);
            }
            configSetter.add(method);
        }
        return schemeMethods;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveToObject.put(Void.TYPE.getName(), class$java$lang$Void == null ? (class$java$lang$Void = DelegatingFileSystemOptionsBuilder.class$("java.lang.Void")) : class$java$lang$Void);
        primitiveToObject.put(Boolean.TYPE.getName(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = DelegatingFileSystemOptionsBuilder.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveToObject.put(Byte.TYPE.getName(), class$java$lang$Byte == null ? (class$java$lang$Byte = DelegatingFileSystemOptionsBuilder.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveToObject.put(Character.TYPE.getName(), class$java$lang$Character == null ? (class$java$lang$Character = DelegatingFileSystemOptionsBuilder.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveToObject.put(Short.TYPE.getName(), class$java$lang$Short == null ? (class$java$lang$Short = DelegatingFileSystemOptionsBuilder.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveToObject.put(Integer.TYPE.getName(), class$java$lang$Integer == null ? (class$java$lang$Integer = DelegatingFileSystemOptionsBuilder.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveToObject.put(Long.TYPE.getName(), class$java$lang$Long == null ? (class$java$lang$Long = DelegatingFileSystemOptionsBuilder.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveToObject.put(Double.TYPE.getName(), class$java$lang$Double == null ? (class$java$lang$Double = DelegatingFileSystemOptionsBuilder.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveToObject.put(Float.TYPE.getName(), class$java$lang$Float == null ? (class$java$lang$Float = DelegatingFileSystemOptionsBuilder.class$("java.lang.Float")) : class$java$lang$Float);
    }

    private static class Context {
        private final FileSystemOptions fso;
        private final String scheme;
        private final String name;
        private final Object[] values;
        private List configSetters;
        private FileSystemConfigBuilder fileSystemConfigBuilder;

        private Context(FileSystemOptions fso, String scheme, String name, Object[] values) {
            this.fso = fso;
            this.scheme = scheme;
            this.name = name;
            this.values = values;
        }
    }
}

