/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.dsl.transform;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.collect.ImmutableList;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.dsl.ModifiableClass;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.transform.AddFields;
import com.crashlytics.tools.android.onboard.dsl.transform.AddImports;
import com.crashlytics.tools.android.onboard.dsl.transform.AddMethod;
import com.crashlytics.tools.android.onboard.dsl.transform.AddParameterAt;
import com.crashlytics.tools.android.onboard.dsl.transform.AddStatementsBefore;
import com.crashlytics.tools.android.onboard.dsl.transform.ClassTransform;
import com.crashlytics.tools.android.onboard.dsl.transform.DeleteMethod;
import com.crashlytics.tools.android.onboard.dsl.transform.TransformIf;

public class CodeChangeBuilder
implements ClassTransform<Void> {
    private final ImmutableList<ClassTransform<?>> _transforms;

    public static CodeChangeBuilder create() {
        return new CodeChangeBuilder(ImmutableList.<ClassTransform<?>>of());
    }

    public CodeChangeBuilder(ImmutableList<ClassTransform<?>> transforms) {
        this._transforms = transforms;
    }

    public CodeChangeBuilder with(ClassTransform<?> transform) {
        return new CodeChangeBuilder((ImmutableList<ClassTransform<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this._transforms)).add(transform)).build());
    }

    @Override
    public Void apply(ModifiableClass modifiableClass) throws OnboardException {
        for (ClassTransform classTransform : this._transforms) {
            classTransform.apply(modifiableClass);
        }
        return null;
    }

    public CodeChangeBuilder addImports(String ... imports) {
        return this.with(new AddImports(imports));
    }

    public CodeChangeBuilder add(NestedMethodInvocation invocation) {
        return this.with(new AddMethod(invocation));
    }

    public static ClassTransform<Boolean> delete(NestedMethodInvocation invocation) {
        return new DeleteMethod(invocation);
    }

    public CodeChangeBuilder transformIf(ClassTransform<Boolean> transformCondition, ClassTransform<?> ... transforms) {
        return this.with(new TransformIf(transformCondition, transforms));
    }

    public static ClassTransform<Boolean> addParameterAt(NestedMethodInvocation invocation, String parameter) {
        return new AddParameterAt(invocation, parameter);
    }

    public static ClassTransform<Void> insertStatementBefore(NestedMethodInvocation invocation, String statement) {
        return new AddStatementsBefore(invocation, statement);
    }

    public static ClassTransform<Void> insertFields(String ... statements) {
        return new AddFields(statements);
    }

    public String toString() {
        return Joiner.on('\n').join(this._transforms);
    }
}

