/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.dsl.transform;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.dsl.ModifiableClass;
import com.crashlytics.tools.android.onboard.dsl.transform.ClassTransform;
import com.crashlytics.tools.utils.StringUtils;
import java.util.Arrays;

public class TransformIf
implements ClassTransform<Void> {
    private final ClassTransform<Boolean> _conditionedTransformer;
    private final ClassTransform<?>[] _consequentTransformers;

    public TransformIf(ClassTransform<Boolean> conditionedTransformer, ClassTransform<?> ... conditionalTransformers) {
        this._conditionedTransformer = conditionedTransformer;
        this._consequentTransformers = conditionalTransformers;
    }

    @Override
    public Void apply(ModifiableClass modifiableClass) throws OnboardException {
        if (this._conditionedTransformer.apply(modifiableClass).booleanValue()) {
            for (ClassTransform<?> consequent : this._consequentTransformers) {
                consequent.apply(modifiableClass);
            }
        }
        return null;
    }

    public String toString() {
        return "if " + this._conditionedTransformer + " then {\n" + StringUtils.tabAppender(2).apply(Joiner.on("\n").join(Arrays.asList(this._consequentTransformers)) + "\n\t}");
    }
}

