/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.dependency.IvyModuleResolver;
import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.android.project.library.AndroidLibraryGraph;
import com.crashlytics.tools.utils.SparseDirectedGraph;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;

public class AndroidLibraryGraphFactory {
    private static final String DEFAULT_CONFIGURATION = "default";
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on('\n').withKeyValueSeparator(": ");
    public static final String IVY_MAVEN_URL = "https://twittersdk.artifactoryonline.com/twittersdk/repo";

    public static ResolveReport getDefaultResolution(ModuleRevisionId[] kits) throws IOException, ParseException, DependencyException {
        return IvyModuleResolver.createMavenCentralBackedAuthenticatedResolver("Artifactory Realm", "twittersdk.artifactoryonline.com", OnboardingConstants.TWITTER_SDK_REPOSITORY.getUsername(), OnboardingConstants.TWITTER_SDK_REPOSITORY.getPassword(), IVY_MAVEN_URL).resolveModules(kits);
    }

    public static AndroidLibraryGraph getLibraries(ResolveReport report, ModuleRevisionId[] requestedLibraries) throws DependencyException {
        DeveloperTools.logD("Resolution:\n" + Joiner.on("\n").join(report.getArtifacts()));
        if (report.getUnresolvedDependencies().length > 0) {
            throw new DependencyException("Crashlytics found " + report.getUnresolvedDependencies().length + " unresolved dependencies.");
        }
        Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions = AndroidLibraryGraphFactory.resolveIds(report.getDependencies(), report.getAllArtifactsReports());
        Map<ModuleRevisionId, AndroidLibrary> revisionLibraries = AndroidLibraryGraphFactory.getAndroidLibraries(revisionResolutions, report.getAllArtifactsReports());
        return new AndroidLibraryGraph(new SparseDirectedGraph<AndroidLibrary>(AndroidLibraryGraphFactory.setupDependencies(revisionLibraries, AndroidLibraryGraphFactory.getDependencyList(revisionResolutions, report.getDependencies()))), AndroidLibraryGraphFactory.getRootLibraries(revisionResolutions, revisionLibraries, requestedLibraries));
    }

    private static Map<ModuleRevisionId, ModuleRevisionId> resolveIds(List<IvyNode> dependencies, ArtifactDownloadReport[] artifactReports) {
        HashMap<ModuleRevisionId, ModuleRevisionId> revisionResolutions = new HashMap<ModuleRevisionId, ModuleRevisionId>();
        for (IvyNode dependency : dependencies) {
            Optional<ModuleRevisionId> revisionResolution = dependency.isEvicted(DEFAULT_CONFIGURATION) && !dependency.getAllEvictingNodes().isEmpty() ? AndroidLibraryGraphFactory.getEvictedId(dependency) : AndroidLibraryGraphFactory.getResolvedId(dependency);
            DeveloperTools.logD("Resolved: " + dependency.getId() + " to: " + revisionResolution);
            if (!revisionResolution.isPresent()) continue;
            revisionResolutions.put(dependency.getId(), revisionResolution.get());
        }
        for (ArtifactDownloadReport report : artifactReports) {
            ModuleRevisionId id = report.getArtifact().getModuleRevisionId();
            if (revisionResolutions.containsKey(id)) continue;
            DeveloperTools.logD("Resolving unresolved " + id + " to" + id);
            revisionResolutions.put(id, id);
        }
        DeveloperTools.logD("Resolved Ids:\n" + MAP_JOINER.join(revisionResolutions));
        return revisionResolutions;
    }

    private static Optional<ModuleRevisionId> getResolvedId(IvyNode node) {
        return node.getModuleRevision() == null ? Optional.absent() : Optional.of(node.getModuleRevision().getId());
    }

    private static Optional<ModuleRevisionId> getEvictedId(IvyNode node) {
        return Optional.of(((IvyNode)node.getAllEvictingNodes().iterator().next()).getId());
    }

    public static Map<ModuleRevisionId, List<ModuleRevisionId>> getDependencyList(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, List<IvyNode> dependencies) {
        HashMap<ModuleRevisionId, List<ModuleRevisionId>> dependencyList = new HashMap<ModuleRevisionId, List<ModuleRevisionId>>();
        for (IvyNode node : dependencies) {
            DependencyDescriptor[] dependencyDescriptors;
            ResolvedModuleRevision moduleRevision = node.getModuleRevision();
            if (moduleRevision == null) continue;
            DeveloperTools.logD("Node:" + node + " " + moduleRevision);
            DeveloperTools.logD("Id:" + moduleRevision.getId());
            LinkedList<ModuleRevisionId> list = new LinkedList<ModuleRevisionId>();
            dependencyList.put(moduleRevision.getId(), list);
            for (DependencyDescriptor desc : dependencyDescriptors = node.getDescriptor().getDependencies()) {
                ModuleRevisionId unresolvedDependencyId = desc.getDependencyRevisionId();
                ModuleRevisionId resolvedDependencyId = revisionResolutions.get(unresolvedDependencyId);
                if (resolvedDependencyId == null) {
                    DeveloperTools.logD("Dependency Unresolved: " + moduleRevision.getId() + " -> " + unresolvedDependencyId);
                    continue;
                }
                DeveloperTools.logD("Dependency Resolved: " + moduleRevision.getId() + " -> " + resolvedDependencyId);
                list.add(resolvedDependencyId);
            }
        }
        DeveloperTools.logD("Dependencies:\n" + MAP_JOINER.join(dependencyList));
        return dependencyList;
    }

    public static Map<ModuleRevisionId, AndroidLibrary> getAndroidLibraries(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, ArtifactDownloadReport[] artifactReports) {
        HashMap<ModuleRevisionId, AndroidLibrary> revisionLibraries = new HashMap<ModuleRevisionId, AndroidLibrary>();
        for (ArtifactDownloadReport report : artifactReports) {
            Artifact artifact = report.getArtifact();
            ModuleRevisionId resolvedId = revisionResolutions.get(artifact.getModuleRevisionId());
            if (artifact.getType().equals("javadoc") || !report.getExt().equals("aar") && revisionLibraries.containsKey(resolvedId)) continue;
            revisionLibraries.put(resolvedId, new AndroidLibrary(AndroidLibrary.getModuleName(resolvedId.getModuleId()), report.getLocalFile(), resolvedId.getRevision(), report.getArtifact().getPublicationDate().getTime()));
        }
        DeveloperTools.logD("Libraries:\n" + MAP_JOINER.join(revisionLibraries));
        return revisionLibraries;
    }

    private static Map<AndroidLibrary, Set<AndroidLibrary>> setupDependencies(Map<ModuleRevisionId, AndroidLibrary> revisionLibraries, Map<ModuleRevisionId, List<ModuleRevisionId>> revisionDependencies) throws DependencyException {
        HashMap<AndroidLibrary, Set<AndroidLibrary>> libraryDependencies = new HashMap<AndroidLibrary, Set<AndroidLibrary>>();
        for (Map.Entry<ModuleRevisionId, List<ModuleRevisionId>> libraryEntry : revisionDependencies.entrySet()) {
            HashSet<AndroidLibrary> libraries = new HashSet<AndroidLibrary>();
            for (ModuleRevisionId revision : libraryEntry.getValue()) {
                AndroidLibrary library = revisionLibraries.get(revision);
                if (library == null) {
                    throw new DependencyException("Crashlytics found a dependency without a resolved file." + revision);
                }
                libraries.add(library);
            }
            libraryDependencies.put(revisionLibraries.get(libraryEntry.getKey()), libraries);
        }
        DeveloperTools.logD("Library sets:\n" + MAP_JOINER.join(libraryDependencies));
        return libraryDependencies;
    }

    public static List<AndroidLibrary> getRootLibraries(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, Map<ModuleRevisionId, AndroidLibrary> revisionLibraries, ModuleRevisionId[] requestedLibraries) throws DependencyException {
        LinkedList<AndroidLibrary> rootLibraries = new LinkedList<AndroidLibrary>();
        for (ModuleRevisionId id : requestedLibraries) {
            ModuleRevisionId resolvedId = revisionResolutions.get(id);
            if (resolvedId == null) {
                throw new DependencyException("Crashlytics was not able to resolve " + id);
            }
            AndroidLibrary library = revisionLibraries.get(resolvedId);
            if (library == null) {
                throw new DependencyException("Crashlytics failed to identify the android library for a requested revision id: " + id);
            }
            rootLibraries.add(library);
        }
        return rootLibraries;
    }

    public static class DependencyException
    extends Exception {
        public DependencyException(String message) {
            super(message);
        }
    }
}

