/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ApiUtils;
import com.crashlytics.api.ota.Device;
import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.PersonEvent;
import com.crashlytics.api.ota.PersonGroup;
import com.crashlytics.api.ota.PersonGroupJsonTransform;
import com.crashlytics.api.ota.PersonInvitation;
import com.crashlytics.reloc.org.json.simple.JSONArray;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.tools.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PersonJsonTransform {
    private static final String ID = "id";
    private static final String EMAIL_STATUS = "email_status";
    private static final String INVITATION_ID = "invitation_id";
    private static final String OVERALL_STATUS_MODIFIED_AT = "overall_status_modified_at";
    private static final String EMAIL = "email";
    private static final String EVENTS = "events";
    private static final String NAME = "name";
    private static final String OVERALL_STATUS = "overall_status";
    private static final String DEVICES = "devices";
    private static final String INVITATION = "invitation";
    private static final String ACCESS = "access";
    private static final String GROUPS = "groups";
    private static final String STATUS = "status";
    private static final String MODIFIED_AT = "modified_at";
    private static final String EVENT = "event";
    private static final String EVENT_AT = "event_at";
    private static final String BUILD_INSTANCE_ID = "build_instance_id";
    private final PersonGroupJsonTransform _groupTransform = new PersonGroupJsonTransform();

    public Person createPersonFrom(JSONObject personJson) {
        if (personJson == null) {
            return null;
        }
        String testerId = NumberUtils.toString((Long)personJson.get(ID));
        String emailStatus = (String)personJson.get(EMAIL_STATUS);
        String invitationId = NumberUtils.toString((Long)personJson.get(INVITATION_ID));
        Date overallStatusModifiedAt = null;
        Long modifiedAtSecs = (Long)personJson.get(OVERALL_STATUS_MODIFIED_AT);
        if (modifiedAtSecs != null) {
            overallStatusModifiedAt = ApiUtils.dateFromEpochSeconds(modifiedAtSecs);
        }
        String email = (String)personJson.get(EMAIL);
        ArrayList<PersonEvent> events = new ArrayList<PersonEvent>();
        JSONArray eventsJson = (JSONArray)personJson.get(EVENTS);
        if (eventsJson != null) {
            for (Object obj : eventsJson) {
                JSONObject eventJson = (JSONObject)obj;
                events.add(this.createPersonEventFrom(eventJson));
            }
        }
        String name = (String)personJson.get(NAME);
        String overallStatus = (String)personJson.get(OVERALL_STATUS);
        String access = (String)personJson.get(ACCESS);
        List<Device> devices = this.createDevicesFrom((JSONArray)personJson.get(DEVICES));
        List<PersonGroup> groups = this.createGroupsFrom((JSONArray)personJson.get(GROUPS));
        PersonInvitation invitation = this.createPersonInvitationFrom((JSONObject)personJson.get(INVITATION));
        return new Person(testerId, emailStatus, invitationId, overallStatusModifiedAt, email, events, name, overallStatus, devices, invitation, access, groups);
    }

    private List<Device> createDevicesFrom(JSONArray jsonDevices) {
        if (jsonDevices == null) {
            return Collections.emptyList();
        }
        ArrayList<Device> devices = new ArrayList<Device>(jsonDevices.size());
        for (Object obj : jsonDevices) {
            JSONObject deviceJson = (JSONObject)obj;
            devices.add(new Device(deviceJson));
        }
        return devices;
    }

    private List<PersonGroup> createGroupsFrom(JSONArray jsonGroups) {
        if (jsonGroups == null) {
            return Collections.emptyList();
        }
        ArrayList<PersonGroup> groups = new ArrayList<PersonGroup>(jsonGroups.size());
        for (Object obj : jsonGroups) {
            JSONObject groupJson = (JSONObject)obj;
            groups.add(this._groupTransform.createGroupFrom(groupJson));
        }
        return groups;
    }

    private PersonEvent createPersonEventFrom(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String event = (String)jsonObject.get(EVENT);
        Date eventAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(EVENT_AT));
        String buildInstanceId = (String)jsonObject.get(BUILD_INSTANCE_ID);
        return new PersonEvent(event, eventAt, buildInstanceId);
    }

    private PersonInvitation createPersonInvitationFrom(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long id = (Long)jsonObject.get(ID);
        String status = (String)jsonObject.get(STATUS);
        Date modifiedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(MODIFIED_AT));
        return new PersonInvitation(id, status, modifiedAt);
    }
}

