/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidVersion
implements Comparable<AndroidVersion> {
    private final int mApiLevel;
    private final String mCodename;

    public AndroidVersion(int n, String string) {
        this.mApiLevel = n;
        this.mCodename = string;
    }

    public AndroidVersion(Properties properties, int n, String string) {
        if (properties == null) {
            this.mApiLevel = n;
            this.mCodename = string;
        } else {
            this.mApiLevel = Integer.parseInt(properties.getProperty("AndroidVersion.ApiLevel", Integer.toString(n)));
            this.mCodename = properties.getProperty("AndroidVersion.CodeName", string);
        }
    }

    public AndroidVersion(Properties properties) throws AndroidVersionException {
        NumberFormatException numberFormatException = null;
        String string = properties.getProperty("AndroidVersion.ApiLevel", null);
        if (string != null) {
            try {
                this.mApiLevel = Integer.parseInt(string);
                this.mCodename = properties.getProperty("AndroidVersion.CodeName", null);
                return;
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
        }
        throw new AndroidVersionException("AndroidVersion.ApiLevel not found!", numberFormatException);
    }

    public void saveProperties(Properties properties) {
        properties.setProperty("AndroidVersion.ApiLevel", Integer.toString(this.mApiLevel));
        if (this.mCodename != null) {
            properties.setProperty("AndroidVersion.CodeName", this.mCodename);
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        return Integer.toString(this.mApiLevel);
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean canRun(AndroidVersion androidVersion) {
        if (androidVersion.mCodename != null) {
            return androidVersion.mCodename.equals(this.mCodename);
        }
        return this.mApiLevel >= androidVersion.mApiLevel;
    }

    public boolean equals(int n) {
        return this.mCodename == null && n == this.mApiLevel;
    }

    public boolean equals(Object object) {
        if (object instanceof AndroidVersion) {
            AndroidVersion androidVersion = (AndroidVersion)object;
            if (this.mCodename == null) {
                return androidVersion.mCodename == null && this.mApiLevel == androidVersion.mApiLevel;
            }
            return this.mCodename.equals(androidVersion.mCodename) && this.mApiLevel == androidVersion.mApiLevel;
        }
        if (object instanceof String) {
            if (this.mCodename != null) {
                return this.mCodename.equals(object);
            }
            try {
                int n = Integer.parseInt((String)object);
                return n == this.mApiLevel;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.mCodename != null) {
            return this.mCodename.hashCode();
        }
        return this.mApiLevel;
    }

    public String toString() {
        String string = String.format("API %1$d", this.mApiLevel);
        if (this.isPreview()) {
            string = string + String.format(", %1$s preview", this.mCodename);
        }
        return string;
    }

    @Override
    public int compareTo(AndroidVersion androidVersion) {
        return this.compareTo(androidVersion.mApiLevel, androidVersion.mCodename);
    }

    private int compareTo(int n, String string) {
        if (this.mCodename == null) {
            if (string == null) {
                return this.mApiLevel - n;
            }
            if (this.mApiLevel == n) {
                return -1;
            }
            return this.mApiLevel - n;
        }
        if (this.mApiLevel == n) {
            if (string == null) {
                return 1;
            }
            return this.mCodename.compareTo(string);
        }
        return this.mApiLevel - n;
    }

    public boolean isGreaterOrEqualThan(int n) {
        return this.compareTo(n, null) >= 0;
    }

    public static final class AndroidVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AndroidVersionException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

