/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConfigGenerator {
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_DEBUG = "#DEBUG#";
    private final String mGenFolder;
    private final String mAppPackage;
    private final boolean mDebug;

    public BuildConfigGenerator(String string, String string2, boolean bl) {
        this.mGenFolder = string;
        this.mAppPackage = string2;
        this.mDebug = bl;
    }

    public File getFolderPath() {
        File file = new File(this.mGenFolder);
        return new File(file, this.mAppPackage.replace('.', File.separatorChar));
    }

    public File getBuildConfigFile() {
        File file = this.getFolderPath();
        return new File(file, BUILD_CONFIG_NAME);
    }

    public void generate() throws IOException {
        String string = this.readEmbeddedTextFile("BuildConfig.template");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PH_PACKAGE, this.mAppPackage);
        hashMap.put(PH_DEBUG, Boolean.toString(this.mDebug));
        String string2 = this.replaceParameters(string, hashMap);
        File file = this.getFolderPath();
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        File file2 = new File(file, BUILD_CONFIG_NAME);
        this.writeFile(file2, string2);
    }

    private String readEmbeddedTextFile(String string) throws IOException {
        InputStream inputStream = BuildConfigGenerator.class.getResourceAsStream(string);
        if (inputStream != null) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder(bufferedReader.readLine());
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append('\n');
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        throw new IOException("BuildConfig template is missing!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = byteArrayInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private String replaceParameters(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getValue();
            if (string2 == null) continue;
            string = string.replaceAll(entry.getKey(), string2);
        }
        return string;
    }
}

