/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.Organization;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class User {
    private final String _email;
    private final String _name;
    private final String _token;
    private final List<Organization> _orgs;

    public User(String string, String string2, String string3) {
        if (string.isEmpty() || string3.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty value: " + string + ", " + string3);
        }
        this._email = string;
        this._name = string2;
        this._token = string3;
        this._orgs = new LinkedList<Organization>();
    }

    public User(JSONObject jSONObject) {
        this((String)jSONObject.get("email"), (String)jSONObject.get("name"), (String)jSONObject.get("token"));
        JSONArray jSONArray = (JSONArray)jSONObject.get("organizations");
        if (jSONArray != null) {
            for (Object e : jSONArray) {
                this._orgs.add(new Organization((JSONObject)e));
            }
        }
    }

    public List<Organization> getOrgs() {
        return Collections.unmodifiableList(this._orgs);
    }

    public void setOrgs(Collection<Organization> collection) {
        this._orgs.clear();
        this._orgs.addAll(collection);
    }

    public String getEmail() {
        return this._email;
    }

    public String getName() {
        return this._name;
    }

    public String getToken() {
        return this._token;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._email == null ? 0 : this._email.hashCode());
        n = 31 * n + (this._name == null ? 0 : this._name.hashCode());
        n = 31 * n + (this._token == null ? 0 : this._token.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        User user = (User)object;
        return this._email.equals(user._email) && this._token.equals(user._token);
    }

    public String toString() {
        return this._email;
    }
}

