/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.android.io.FileWrapper;
import com.android.sdklib.xml.AndroidManifestParser;
import com.android.sdklib.xml.ManifestData;
import com.crashlytics.tools.android.project.ManifestData;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultManifestData
implements ManifestData {
    private static final String XMLTAG_VERSION_NAME = "android:versionName";
    private static final String XMLTAG_ICON = "android:icon";
    private static final String PNG_EXTENSION = ".png";
    private final File _manifestFile;
    private final com.android.sdklib.xml.ManifestData _data;
    private final String _versionName;
    private final Set<String> _services = new HashSet<String>();
    private final Set<String> _usesPermissions = new HashSet<String>();
    private final Hashtable<String, String> _metaData = new Hashtable();
    private String _iconName = null;
    private String _applicationClass = null;
    private static final FilenameFilter DRAWABLE_FOLDER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("drawable") && new File(file, string).isDirectory();
        }
    };
    private static final FilenameFilter PNG_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(DefaultManifestData.PNG_EXTENSION);
        }
    };

    public DefaultManifestData(File file) throws IOException {
        this._manifestFile = file;
        FileWrapper fileWrapper = new FileWrapper(this._manifestFile);
        com.android.sdklib.xml.ManifestData manifestData = null;
        try {
            manifestData = AndroidManifestParser.parse(fileWrapper, true, null);
        }
        catch (Exception exception) {
            throw new IOException("Could not parse " + this._manifestFile + " as an Android manifest.", exception);
        }
        this._data = manifestData;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            this._versionName = element.getAttribute(XMLTAG_VERSION_NAME);
            this.initValues(element);
        }
        catch (Exception exception) {
            throw new IOException("Could not extract android:versionName from manifest file: " + this._manifestFile, exception);
        }
    }

    protected DefaultManifestData() {
        this._manifestFile = null;
        this._versionName = null;
        this._data = null;
    }

    private void initValues(Element element) {
        String string;
        Object object;
        this._services.clear();
        this._iconName = null;
        NodeList nodeList = element.getElementsByTagName("application");
        if (nodeList.getLength() == 0) {
            return;
        }
        Element element2 = (Element)nodeList.item(0);
        if (element2.hasAttribute(XMLTAG_ICON)) {
            this._iconName = element2.getAttribute(XMLTAG_ICON).replaceFirst("@drawable/", "");
        }
        if (element2.hasAttribute("android:name")) {
            this._applicationClass = element2.getAttribute("android:name");
            if (this._applicationClass.startsWith(".")) {
                this._applicationClass = this._data.getPackage() + this._applicationClass;
            }
        }
        NodeList nodeList2 = element2.getElementsByTagName("service");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            String string2 = ((Element)nodeList2.item(i)).getAttribute("name");
            if (string2 == null) continue;
            this._services.add(string2);
        }
        NodeList nodeList3 = element2.getElementsByTagName("meta-data");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            Element element3 = (Element)nodeList3.item(i);
            object = element3.getAttribute("android:name");
            string = element3.getAttribute("android:value");
            this._metaData.put((String)object, string);
        }
        NodeList nodeList4 = element.getElementsByTagName("uses-permission");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            object = (Element)nodeList4.item(i);
            string = object.getAttribute("android:name");
            this._usesPermissions.add(string);
        }
    }

    @Override
    public File getLauncherIcon() {
        File file = new File(this._manifestFile.getParentFile(), "res");
        if (this._iconName == null || !file.exists()) {
            return null;
        }
        int n = this._iconName.length() + PNG_EXTENSION.length();
        for (File file2 : file.listFiles(DRAWABLE_FOLDER_FILTER)) {
            for (String string : file2.list(PNG_FILE_FILTER)) {
                if (string.length() != n || !string.startsWith(this._iconName)) continue;
                return new File(file2.getAbsoluteFile(), string);
            }
        }
        return null;
    }

    @Override
    public String getPackage() {
        return this._data.getPackage();
    }

    @Override
    public int getVersionCode() {
        return this._data.getVersionCode();
    }

    @Override
    public String getVersionName() {
        return this._versionName;
    }

    @Override
    public boolean declaresService(String string) {
        return this._services.contains(string);
    }

    @Override
    public String getMainActivity() {
        ManifestData.Activity activity = this._data.getLauncherActivity();
        return activity == null ? null : activity.getName();
    }

    @Override
    public String getApplicationClass() {
        return this._applicationClass;
    }

    @Override
    public Hashtable<String, String> getMetaData() {
        return this._metaData;
    }

    @Override
    public boolean usesPermission(String string) {
        return this._usesPermissions.contains(string);
    }
}

