/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.App;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.Software;
import com.crashlytics.api.User;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class RestfulWebApi
implements WebApi {
    private static final String FATAL_TYPE = "fatal";
    private static final String NONFATAL_TYPE = "nonfatal";
    private static final String HTTP_PROXY_PORT_PROP = "http.proxyPort";
    private static final String HTTP_PROXY_HOST_PROP = "http.proxyHost";
    private static final String HTTP_PROXY_USER_PROP = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD_PROP = "http.proxyPassword";
    private static final String HTTPS_PROXY_PORT_PROP = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST_PROP = "https.proxyHost";
    private static final String HTTPS_PROXY_USER_PROP = "https.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD_PROP = "https.proxyPassword";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String DEV_TOKEN_HEADER = "X-CRASHLYTICS-DEVELOPER-TOKEN";
    private static final String ACCESS_TOKEN_HEADER = "X-CRASHLYTICS-ACCESS-TOKEN";
    private static final String REQUEST_ID_HEADER = "X-Request-Id";
    private static final String DEV_TOKEN = "ed8fc3dc68a7475cc970eb1e9c0cb6603b0a3ea2";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String USER_TAG = "User";
    private static final String ORGS_TAG = "Orgs";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private User _user = null;
    private List<App> _appsCache = null;
    private List<Organization> _orgsCache = null;
    private Map<App, List<Issue>> _issuesCache;
    private String _userAgent;
    private String _baseApiUrl;

    public RestfulWebApi() {
        this("https://api.crashlytics.com");
    }

    public RestfulWebApi(String string) {
        this._baseApiUrl = string;
        this._issuesCache = new HashMap<App, List<Issue>>();
        this.loadUserFromCache();
    }

    @Override
    public final synchronized void logout() {
        this.setUser(null);
        this.deleteFileInCache(USER_TAG);
        this.deleteFileInCache(ORGS_TAG);
        this._appsCache = null;
        this._orgsCache = null;
    }

    @Override
    public synchronized void setUserAgent(String string) {
        this._userAgent = string;
    }

    @Override
    public final synchronized User authenticateUser(String string, String string2) throws IOException {
        JSONObject jSONObject;
        this.logout();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("email", string);
        jSONObject2.put("password", string2);
        String string3 = this.getBaseApiUrl() + "/api/v2/session";
        URI uRI = null;
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return null;
        }
        try {
            jSONObject = (JSONObject)this.postJSON(uRI, jSONObject2);
        }
        catch (AuthenticationException authenticationException) {
            jSONObject = null;
        }
        if (jSONObject != null) {
            this.setUser(new User(jSONObject));
            this.writeJSONToFile(USER_TAG, jSONObject);
            JSONArray jSONArray = (JSONArray)jSONObject.get("organizations");
            if (jSONArray != null) {
                this.writeJSONToFile(ORGS_TAG, jSONArray);
                this._orgsCache = new LinkedList<Organization>();
                for (int i = 0; i < jSONArray.size(); ++i) {
                    this._orgsCache.add(new Organization((JSONObject)jSONArray.get(i)));
                }
            }
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticate(final String string, final String string2, final WebApi.ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user = null;
                try {
                    user = RestfulWebApi.this.authenticateUser(string, string2);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAuthenticateException(RestfulWebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }).start();
    }

    @Override
    public final synchronized User authenticateWithToken(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ACCESS_TOKEN_HEADER, string);
        String string2 = this.getBaseApiUrl() + "/api/v2/session";
        URI uRI = null;
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return null;
        }
        try {
            JSONObject jSONObject = (JSONObject)this.getJSON(uRI, hashMap);
            if (jSONObject != null) {
                this.setUser(new User(jSONObject));
            }
        }
        catch (AuthenticationException authenticationException) {
            DeveloperTools.logE("Unable to authenticate user.", authenticationException);
            return null;
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticateWithToken(final String string, final WebApi.ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user = null;
                try {
                    user = RestfulWebApi.this.authenticateWithToken(string);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAuthenticateException(RestfulWebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }).start();
    }

    @Override
    public synchronized List<Organization> getOrgs(boolean bl) throws IOException, AuthenticationException {
        if (!bl && this._orgsCache != null) {
            return Collections.unmodifiableList(this._orgsCache);
        }
        this._orgsCache = new LinkedList<Organization>();
        String string = this.getBaseApiUrl() + "/api/v2/organizations";
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return null;
        }
        JSONArray jSONArray = (JSONArray)this.getJSON(uRI, Collections.<String, String>emptyMap());
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.size(); ++i) {
                this._orgsCache.add(new Organization((JSONObject)jSONArray.get(i)));
            }
            this.writeJSONToFile(ORGS_TAG, jSONArray);
        }
        return Collections.unmodifiableList(this._orgsCache);
    }

    @Override
    public void fetchApps(final WebApi.ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<App> list = null;
                try {
                    list = RestfulWebApi.this.getApps(true);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAppException(RestfulWebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onRetrievedApps(RestfulWebApi.this, list);
                }
            }
        }).start();
    }

    @Override
    public List<App> getApps(Organization organization, boolean bl) throws IOException, AuthenticationException {
        List<App> list = this.getApps(bl);
        LinkedList<App> linkedList = new LinkedList<App>();
        for (App app : list) {
            if (!app.getOrganization().equals(organization)) continue;
            linkedList.add(app);
        }
        return linkedList;
    }

    @Override
    public synchronized List<App> getApps(boolean bl) throws IOException, AuthenticationException {
        if (!bl && this._appsCache != null) {
            return Collections.unmodifiableList(this._appsCache);
        }
        this._appsCache = new LinkedList<App>();
        List<Organization> list = this.getOrgs(true);
        for (Organization organization : list) {
            String string = this.getBaseApiUrl() + "/api/v2/organizations/" + organization.getId() + "/platforms/android/apps";
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
                return null;
            }
            JSONArray jSONArray = (JSONArray)this.getJSON(uRI, Collections.<String, String>emptyMap());
            if (jSONArray == null) continue;
            for (int i = 0; i < jSONArray.size(); ++i) {
                App app = new App((JSONObject)jSONArray.get(i), organization);
                if (!app.getPlatform().equalsIgnoreCase("android")) continue;
                this._appsCache.add(app);
            }
        }
        return Collections.unmodifiableList(this._appsCache);
    }

    @Override
    public synchronized List<Issue> getIssues(App app, boolean bl) throws IOException, AuthenticationException {
        LinkedList<Issue> linkedList = new LinkedList<Issue>();
        linkedList.addAll(this.getIssues(app, bl, FATAL_TYPE));
        linkedList.addAll(this.getIssues(app, bl, NONFATAL_TYPE));
        return linkedList;
    }

    private synchronized List<Issue> getIssues(App app, boolean bl, String string) throws IOException, AuthenticationException {
        if (bl) {
            this._issuesCache = new HashMap<App, List<Issue>>();
        }
        if (!this._issuesCache.containsKey(app)) {
            String string2 = this.getBaseApiUrl() + "/api/v2/organizations/" + app.getOrganization().getId() + "/apps/" + app.getId() + "/issues?event_type_equals=" + string;
            URI uRI = null;
            try {
                uRI = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
                return null;
            }
            JSONArray jSONArray = (JSONArray)this.getJSON(uRI, Collections.<String, String>emptyMap());
            DeveloperTools.logD("Issue RESPONSE:" + jSONArray.toJSONString());
            LinkedList<Issue> linkedList = new LinkedList<Issue>();
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.size(); ++i) {
                    try {
                        linkedList.add(new Issue((JSONObject)jSONArray.get(i), app));
                        continue;
                    }
                    catch (Exception exception) {
                        DeveloperTools.logE("Couldn't parse issue", exception);
                    }
                }
            }
            DeveloperTools.logD("Issues:" + linkedList.size());
            this._issuesCache.put(app, linkedList);
        }
        return this._issuesCache.containsKey(app) ? Collections.unmodifiableList(this._issuesCache.get(app)) : Collections.emptyList();
    }

    @Override
    public boolean sendFile(URL uRL, File file, String string, String string2, Map<String, String> map) throws IOException {
        DeveloperTools.logD("POST file: " + file + " to URL: " + uRL);
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        ContentType contentType = ContentType.create(string);
        this.applyCommonHeadersTo(httpPost);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            multipartEntityBuilder.addPart(object2.getKey(), new StringBody(object2.getValue(), contentType));
        }
        multipartEntityBuilder.addPart(string2, new FileBody(file, contentType));
        httpPost.setEntity(multipartEntityBuilder.build());
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(uRL));
        HttpClient httpClient = this.getClient(proxySettings);
        httpPost.setConfig(proxySettings.getConfig());
        HttpResponse httpResponse = httpClient.execute(httpPost);
        int n = httpResponse.getStatusLine().getStatusCode();
        DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(httpResponse) + "] " + n);
        return n >= 200 && n < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(URL uRL, File file) throws IOException {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        this.applyCommonHeadersTo(httpGet);
        httpGet.addHeader(ACCEPT_HEADER, APPLICATION_OCTET_STREAM);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(uRL));
        HttpClient httpClient = this.getClient(proxySettings);
        httpGet.setConfig(proxySettings.getConfig());
        this.logRequest(httpGet);
        HttpResponse httpResponse = httpClient.execute(httpGet);
        int n = httpResponse.getStatusLine().getStatusCode();
        this.logResponse(httpResponse, n);
        if (n == 200) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                httpResponse.getEntity().writeTo(fileOutputStream);
                fileOutputStream.flush();
                boolean bl = true;
                return bl;
            }
            finally {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        return false;
    }

    private void applyCommonHeadersTo(HttpRequestBase httpRequestBase) {
        httpRequestBase.addHeader(DEV_TOKEN_HEADER, DEV_TOKEN);
        if (this._userAgent != null) {
            httpRequestBase.setHeader(USER_AGENT_HEADER, this._userAgent);
        }
        if (this._user != null) {
            httpRequestBase.addHeader(ACCESS_TOKEN_HEADER, this._user.getToken());
        }
    }

    private Object postJSON(URI uRI, JSONObject jSONObject) throws IOException, AuthenticationException {
        HttpPost httpPost = new HttpPost(uRI);
        if (jSONObject != null) {
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(jSONObject.toString().getBytes());
            byteArrayEntity.setContentType(APPLICATION_JSON);
            httpPost.setEntity(byteArrayEntity);
        }
        return this.requestJSON(httpPost, jSONObject, Collections.<String, String>emptyMap());
    }

    private Object getJSON(URI uRI, Map<String, String> map) throws IOException, AuthenticationException {
        HttpGet httpGet = new HttpGet(uRI);
        return this.requestJSON(httpGet, null, map);
    }

    private Object requestJSON(HttpRequestBase httpRequestBase, JSONObject jSONObject, Map<String, String> map) throws IOException, AuthenticationException {
        this.applyCommonHeadersTo(httpRequestBase);
        httpRequestBase.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            httpRequestBase.addHeader(object2.getKey(), object2.getValue().trim());
        }
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(httpRequestBase));
        HttpClient httpClient = this.getClient(proxySettings);
        httpRequestBase.setConfig(proxySettings.getConfig());
        this.logRequest(httpRequestBase);
        HttpResponse httpResponse = httpClient.execute(httpRequestBase);
        int n = httpResponse.getStatusLine().getStatusCode();
        Object object = null;
        if (n >= 200 && n < 300) {
            object = JSONValue.parse(new InputStreamReader(httpResponse.getEntity().getContent(), Charset.forName("UTF8")));
        } else if (n == 401 || n == 403) {
            throw new AuthenticationException("Crashlytics Authentication failed [reqId=" + RestfulWebApi.getRequestId(httpResponse) + "] " + n);
        }
        this.logResponse(httpResponse, n, object);
        return object;
    }

    private void logRequest(HttpRequestBase httpRequestBase) {
        DeveloperTools.logD("REQUEST: " + httpRequestBase.getURI());
    }

    private void logResponse(HttpResponse httpResponse, int n, Object object) {
        DeveloperTools.logD("RESPONSE: [reqId=" + RestfulWebApi.getRequestId(httpResponse) + "]" + n + ";" + object);
    }

    private void logResponse(HttpResponse httpResponse, int n) {
        DeveloperTools.logD("RESPONSE: [reqId=" + RestfulWebApi.getRequestId(httpResponse) + "]" + n);
    }

    @Override
    public Software getSoftwareIntegration(Organization organization, String string, String string2, String string3) throws IOException {
        return this.getSoftwareIntegration(organization.getApiKey(), string, string2, string3);
    }

    @Override
    public Software getSoftwareIntegration(String string, String string2, String string3, String string4) throws IOException {
        URI uRI;
        try {
            uRI = new URI(this._baseApiUrl + "/api/v2/keys/" + string + "/platforms/" + string2 + "/integrations/" + string3 + "?current_version=" + string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = (JSONObject)this.getJSON(uRI, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException authenticationException) {
            DeveloperTools.logW("Unexpected failed authentication", authenticationException);
        }
        return jSONObject == null ? null : Software.createFromJSON(jSONObject);
    }

    @Override
    public Software getAndroidSDK(Organization organization, String string) throws IOException {
        return this.getAndroidSDK(organization.getApiKey(), string);
    }

    @Override
    public Software getAndroidSDK(String string, String string2) throws IOException {
        URI uRI;
        try {
            uRI = new URI(this._baseApiUrl + "/api/v2/keys/" + string + "/platforms/" + "android" + "/sdks/com.crashlytics.android?current_version=" + string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = (JSONObject)this.getJSON(uRI, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException authenticationException) {
            DeveloperTools.logW("Unexpected failed authentication", authenticationException);
        }
        return jSONObject == null ? null : Software.createFromJSON(jSONObject);
    }

    @Override
    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    @Override
    public User getCurrentUser() {
        return this._user;
    }

    private void setUser(User user) {
        this._user = user;
    }

    private void writeJSONToFile(String string, JSONObject jSONObject) {
        this.writeJSONToFile(string, jSONObject.toJSONString().getBytes(UTF_8));
    }

    private void writeJSONToFile(String string, JSONArray jSONArray) {
        this.writeJSONToFile(string, jSONArray.toJSONString().getBytes(UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJSONToFile(String string, byte[] byArray) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            DeveloperTools.logE("Could not write " + file, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DeveloperTools.logE("Could not close " + file, iOException);
                }
            }
        }
    }

    private void loadUserFromCache() {
        User user;
        JSONObject jSONObject = (JSONObject)this.loadFromCache(USER_TAG);
        if (jSONObject != null && (user = new User(jSONObject)) != null) {
            JSONArray jSONArray = (JSONArray)this.loadFromCache(ORGS_TAG);
            if (jSONArray != null) {
                if (this._orgsCache == null) {
                    this._orgsCache = new LinkedList<Organization>();
                }
                for (int i = 0; i < jSONArray.size(); ++i) {
                    this._orgsCache.add(new Organization((JSONObject)jSONArray.get(i)));
                }
            }
            this.setUser(user);
        }
    }

    private Object loadFromCache(String string) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        if (file.exists()) {
            try {
                String string2 = FileUtils.fileToString(file);
                return JSONValue.parse(string2);
            }
            catch (IOException iOException) {
                DeveloperTools.logE("Could not read cache file " + file, iOException);
            }
        }
        return null;
    }

    private void deleteFileInCache(String string) {
        new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION).delete();
    }

    private static String getRequestId(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader(REQUEST_ID_HEADER);
        return header == null ? "null" : header.getValue();
    }

    @Override
    public void prefetchAppIcons() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (RestfulWebApi.this._user == null) {
                    return;
                }
                try {
                    List<App> list = RestfulWebApi.this.getApps(false);
                    for (App app : list) {
                        app.getCachedIconImageOrNull();
                    }
                }
                catch (AuthenticationException authenticationException) {
                    DeveloperTools.logD("Authentication revoked during icon prefetch.");
                }
                catch (IOException iOException) {
                    DeveloperTools.logW("IOException during icon prefectch.", iOException);
                }
            }
        }).start();
    }

    public HttpClient getClient(ProxySettings proxySettings) throws IOException {
        return proxySettings.getClient();
    }

    public static class ProxySettings {
        private final String _proxyHost;
        private final Integer _proxyPort;
        private final String _proxyUser;
        private final String _proxyPassword;

        public ProxySettings(String string, Integer n, String string2, String string3) {
            this._proxyHost = string;
            this._proxyPort = n;
            this._proxyUser = string2;
            this._proxyPassword = string3;
        }

        public static ProxySettings create(ProtocolScheme protocolScheme) throws IOException {
            String string = protocolScheme.getHost();
            String string2 = protocolScheme.getUser();
            String string3 = protocolScheme.getPassword();
            String string4 = protocolScheme.getPort();
            Integer n = null;
            if (string4 != null) {
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Crashlytics could not read proxy port string.");
                }
            }
            return new ProxySettings(string, n, string2, string3);
        }

        public RequestConfig getConfig() {
            if (this._proxyHost != null && this._proxyPort != null) {
                DeveloperTools.logD("Crashlytics using custom proxy settings: " + this._proxyHost + ":" + this._proxyPort);
                HttpHost httpHost = new HttpHost(this._proxyHost, (int)this._proxyPort);
                return RequestConfig.custom().setProxy(httpHost).build();
            }
            return RequestConfig.DEFAULT;
        }

        public HttpClient getClient() throws IOException {
            if (this._proxyHost != null && this._proxyPort != null && this._proxyUser != null && this._proxyPassword != null) {
                DeveloperTools.logD("Crashlytics using proxy auth:" + this._proxyUser);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this._proxyUser, this._proxyPassword);
                AuthScope authScope = new AuthScope(this._proxyHost, this._proxyPort);
                basicCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
                CloseableHttpClient closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider(basicCredentialsProvider).build();
                return closeableHttpClient;
            }
            return HttpClients.createDefault();
        }
    }

    public static enum ProtocolScheme {
        HTTP("http.proxyHost", "http.proxyUser", "http.proxyPassword", "http.proxyPort"),
        HTTPS("https.proxyHost", "https.proxyUser", "https.proxyPassword", "https.proxyPort"),
        Other(null, null, null, null);

        private String _proxyHostProp;
        private String _proxyUserProp;
        private String _proxyPasswordProp;
        private String _proxyPortProp;

        private ProtocolScheme(String string2, String string3, String string4, String string5) {
            this._proxyHostProp = string2;
            this._proxyUserProp = string3;
            this._proxyPasswordProp = string4;
            this._proxyPortProp = string5;
        }

        public static ProtocolScheme getType(HttpRequestBase httpRequestBase) {
            return ProtocolScheme.getType(httpRequestBase.getURI().getScheme());
        }

        public static ProtocolScheme getType(URL uRL) {
            return ProtocolScheme.getType(uRL.getProtocol());
        }

        public static ProtocolScheme getType(String string) {
            if (string.equalsIgnoreCase("HTTP")) {
                return HTTP;
            }
            if (string.equalsIgnoreCase("HTTPS")) {
                return HTTPS;
            }
            return Other;
        }

        public String getHost() {
            return this._proxyHostProp == null ? null : System.getProperty(this._proxyHostProp);
        }

        public String getUser() {
            return this._proxyUserProp == null ? null : System.getProperty(this._proxyUserProp);
        }

        public String getPassword() {
            return this._proxyPasswordProp == null ? null : System.getProperty(this._proxyPasswordProp);
        }

        public String getPort() {
            return this._proxyPortProp == null ? null : System.getProperty(this._proxyPortProp);
        }
    }
}

