/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public abstract class ReleaseNotesManager {
    public static final String HAS_UPDATED_RELEASE_NOTES_KEY = "com.crashlytics.tools.ide.Ide.HAS_UPDATED_RELEASE_NOTES";
    public static final String HAS_UPDATED_RELEASE_NOTES_DEFAULT = "false";
    private static final String RELEASE_NOTES_FILE_NAME = "release_notes.html";
    private static final String RELEASE_NOTES_FILE_NAME_TMP = "release_notes.html.dl";
    private File _releaseNotesDir;

    public ReleaseNotesManager(File file) {
        this._releaseNotesDir = new File(file, ".release_notes");
        if (!this._releaseNotesDir.exists()) {
            this._releaseNotesDir.mkdirs();
        }
    }

    protected File getReleaseNotesDir() {
        return this._releaseNotesDir;
    }

    public abstract String getReleaseNotesUrl();

    public abstract String getBuiltInReleaseNotesPath();

    public abstract boolean hasReleaseNotesUpdate();

    public abstract void setHasReleaseNotesUpdate(boolean var1);

    public boolean downloadReleaseNotes() {
        String string = this.getReleaseNotesUrl();
        File file = this.getReleaseNotesFileTemp();
        DeveloperTools.logD("Downloading release notes from " + string + " to " + file.getAbsolutePath());
        boolean bl = false;
        try {
            bl = DeveloperTools.getWebApi().downloadFile(new URL(string), file);
        }
        catch (IOException iOException) {
            DeveloperTools.logW("Failed to download release notes.", iOException);
            file.delete();
            return false;
        }
        if (!bl) {
            DeveloperTools.logW("Failed to download release notes.", null);
            file.delete();
        }
        return bl;
    }

    public File getReleaseNotesFile() {
        return new File(this._releaseNotesDir, RELEASE_NOTES_FILE_NAME);
    }

    public File getReleaseNotesFileTemp() {
        return new File(this._releaseNotesDir, RELEASE_NOTES_FILE_NAME_TMP);
    }

    public boolean commitDownloadedReleaseNotes() throws ReleaseNotesCommitException {
        boolean bl;
        boolean bl2 = true;
        File file = this.getReleaseNotesFile();
        File file2 = this.getReleaseNotesFileTemp();
        String string = null;
        String string2 = null;
        if (file.exists() && file2.exists()) {
            try {
                byte[] byArray = FileUtils.readFileToByteArray(file);
                byte[] byArray2 = FileUtils.readFileToByteArray(file2);
                string2 = DigestUtils.shaHex(byArray);
                string = DigestUtils.shaHex(byArray2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl3 = bl = this.hasReleaseNotesUpdate() || string2 == null || string == null || !string2.equals(string);
        if (file2.exists()) {
            bl2 &= file.delete() || !file.exists();
            bl2 &= file2.renameTo(file);
        } else {
            bl2 = false;
        }
        if (!bl2) {
            throw new ReleaseNotesCommitException();
        }
        this.setHasReleaseNotesUpdate(bl);
        return bl;
    }

    public InputStream getReleaseNotesInput() throws IOException {
        return new FileInputStream(this.getReleaseNotesFile());
    }

    public static class ReleaseNotesCommitException
    extends RuntimeException {
        private static final long serialVersionUID = 8368676710690552969L;
    }
}

