/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.SDK;
import com.crashlytics.tools.utils.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class StreamBasedSDK
implements SDK {
    private InputStream _inputStream;

    public StreamBasedSDK(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    @Override
    public boolean exists() {
        return this._inputStream != null;
    }

    public String toString() {
        if (this._inputStream != null) {
            return String.format("SDK stream:( empty )", new Object[0]);
        }
        return String.format("SDK stream:( %s )", this._inputStream.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        if (this._inputStream == null) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new JarInputStream(this._inputStream);
        }
        catch (IOException iOException) {
            DeveloperTools.logW("Crashlytics could not get version information from manifest.", iOException);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                DeveloperTools.logE("Crashlytics could not close manifest jar.", iOException);
            }
        }
        Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
        String string = null;
        if (manifest != null) {
            string = JarUtils.getVersion(manifest, "com/crashlytics/android/");
        }
        return string;
    }

    @Override
    public InputStream getStream() {
        return this._inputStream;
    }
}

