/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.util.Comparator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtils {
    private static final String VERSION_ATTRIBUTE = "Specification-Version";
    public static final Comparator<String> VERSION_STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            String[] stringArray = string.split("\\.", 4);
            String[] stringArray2 = string2.split("\\.", 4);
            for (int i = 0; i < 3; ++i) {
                int n;
                int n2 = Integer.parseInt(stringArray[i]);
                if (n2 < (n = Integer.parseInt(stringArray2[i]))) {
                    return -1;
                }
                if (n2 <= n) continue;
                return 1;
            }
            String string3 = stringArray.length > 3 ? stringArray[3] : "";
            String string4 = stringArray2.length > 3 ? stringArray2[3] : "";
            return string3.compareTo(string4);
        }
    };

    public static final Comparator<Manifest> getVersionComparator(final String string) {
        return new Comparator<Manifest>(){

            @Override
            public int compare(Manifest manifest, Manifest manifest2) {
                return VERSION_STRING_COMPARATOR.compare(JarUtils.getVersion(manifest, string), JarUtils.getVersion(manifest2, string));
            }
        };
    }

    public static String getVersion(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            return attributes.getValue(VERSION_ATTRIBUTE);
        }
        return null;
    }

    public static String extractManifestVersion(File file, String string) {
        String string2 = null;
        if (file != null && file.exists()) {
            try {
                string2 = JarUtils.getVersion(new JarFile(file).getManifest(), string);
            }
            catch (Exception exception) {
                DeveloperTools.logW("Exception while retrieving version from " + file + ".", exception);
                string2 = null;
            }
        }
        return string2;
    }

    public static Manifest getMaybeManifest(File file) {
        try {
            if (file.exists()) {
                return new JarFile(file).getManifest();
            }
        }
        catch (Exception exception) {
            DeveloperTools.logW("Could not read manifest from " + file, exception);
        }
        return null;
    }
}

