/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import com.crashlytics.android.answers.SessionEventMetadata;
import java.util.Collections;
import java.util.Map;

final class SessionEvent {
    public final SessionEventMetadata sessionEventMetadata;
    public final long timestamp;
    public final Type type;
    public final Map<String, String> details;
    private String stringRepresentation;

    public static SessionEvent buildActivityLifecycleEvent(SessionEventMetadata metadata, Type type, Activity activity) {
        Map<String, String> details = Collections.singletonMap("activity", activity.getClass().getName());
        return SessionEvent.buildEvent(metadata, type, details);
    }

    public static SessionEvent buildErrorEvent(SessionEventMetadata metadata, String sessionId) {
        Map<String, String> details = Collections.singletonMap("sessionId", sessionId);
        return SessionEvent.buildEvent(metadata, Type.ERROR, details);
    }

    public static SessionEvent buildCrashEvent(SessionEventMetadata metadata, String sessionId) {
        Map<String, String> details = Collections.singletonMap("sessionId", sessionId);
        return SessionEvent.buildEvent(metadata, Type.CRASH, details);
    }

    public static SessionEvent buildEvent(SessionEventMetadata metadata, Type type, Map<String, String> details) {
        return new SessionEvent(metadata, System.currentTimeMillis(), type, details);
    }

    private SessionEvent(SessionEventMetadata sessionEventMetadata, long timestamp, Type type, Map<String, String> details) {
        this.sessionEventMetadata = sessionEventMetadata;
        this.timestamp = timestamp;
        this.type = type;
        this.details = details;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder sb = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(": appBundleId=").append(this.sessionEventMetadata.appBundleId).append(", executionId=").append(this.sessionEventMetadata.executionId).append(", installationId=").append(this.sessionEventMetadata.installationId).append(", androidId=").append(this.sessionEventMetadata.androidId).append(", advertisingId=").append(this.sessionEventMetadata.advertisingId).append(", betaDeviceToken=").append(this.sessionEventMetadata.betaDeviceToken).append(", buildId=").append(this.sessionEventMetadata.buildId).append(", osVersion=").append(this.sessionEventMetadata.osVersion).append(", deviceModel=").append(this.sessionEventMetadata.deviceModel).append(", appVersionCode=").append(this.sessionEventMetadata.appVersionCode).append(", appVersionName=").append(this.sessionEventMetadata.appVersionName).append(", timestamp=").append(this.timestamp).append(", type=").append((Object)this.type).append(", details=").append(this.details.toString()).append("]");
            this.stringRepresentation = sb.toString();
        }
        return this.stringRepresentation;
    }

    static enum Type {
        CREATE,
        START,
        RESUME,
        SAVE_INSTANCE_STATE,
        PAUSE,
        STOP,
        DESTROY,
        ERROR,
        CRASH,
        INSTALL;

    }
}

