/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.EnabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManager;
import com.crashlytics.android.answers.SessionEventMetadata;
import com.crashlytics.android.answers.SessionEventsHandler;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import java.util.concurrent.ScheduledExecutorService;

@TargetApi(value=14)
class AutoSessionAnalyticsManager
extends SessionAnalyticsManager {
    private static final String EXECUTOR_SERVICE = "Crashlytics Trace Manager";
    private final Application application;
    private final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle bundle) {
            AutoSessionAnalyticsManager.this.onCreate(activity);
        }

        public void onActivityDestroyed(Activity activity) {
            AutoSessionAnalyticsManager.this.onDestroy(activity);
        }

        public void onActivityPaused(Activity activity) {
            AutoSessionAnalyticsManager.this.onPause(activity);
        }

        public void onActivityResumed(Activity activity) {
            AutoSessionAnalyticsManager.this.onResume(activity);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            AutoSessionAnalyticsManager.this.onSaveInstanceState(activity);
        }

        public void onActivityStarted(Activity activity) {
            AutoSessionAnalyticsManager.this.onStart(activity);
        }

        public void onActivityStopped(Activity activity) {
            AutoSessionAnalyticsManager.this.onStop(activity);
        }
    };

    public static AutoSessionAnalyticsManager build(Application application, SessionEventMetadata metadata, SessionAnalyticsFilesManager filesManager, HttpRequestFactory httpRequestFactory) {
        ScheduledExecutorService executor = ExecutorUtils.buildSingleThreadScheduledExecutorService((String)EXECUTOR_SERVICE);
        EnabledSessionAnalyticsManagerStrategy strategy = new EnabledSessionAnalyticsManagerStrategy((Context)application, executor, filesManager, httpRequestFactory);
        SessionEventsHandler eventsHandler = new SessionEventsHandler((Context)application, strategy, filesManager, executor);
        return new AutoSessionAnalyticsManager(metadata, eventsHandler, application);
    }

    AutoSessionAnalyticsManager(SessionEventMetadata metadata, SessionEventsHandler eventsHandler, Application application) {
        super(metadata, eventsHandler);
        this.application = application;
        CommonUtils.logControlled((Context)Answers.getInstance().getContext(), (String)"Registering activity lifecycle callbacks for session analytics.");
        application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    @Override
    public void disable() {
        CommonUtils.logControlled((Context)Answers.getInstance().getContext(), (String)"Unregistering activity lifecycle callbacks for session analytics");
        this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        super.disable();
    }
}

