/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.annotation.TargetApi;
import android.os.Build;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.services.events.EventTransform;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

class SessionEventTransform
implements EventTransform<SessionEvent> {
    static final String APP_BUNDLE_ID_KEY = "appBundleId";
    static final String EXECUTION_ID_KEY = "executionId";
    static final String INSTALLATION_ID_KEY = "installationId";
    static final String ANDROID_ID_KEY = "androidId";
    static final String ADVERTISING_ID_KEY = "advertisingId";
    static final String BETA_DEVICE_TOKEN_KEY = "betaDeviceToken";
    static final String BUILD_ID_KEY = "buildId";
    static final String OS_VERSION_KEY = "osVersion";
    static final String DEVICE_MODEL_KEY = "deviceModel";
    static final String APP_VERSION_CODE_KEY = "appVersionCode";
    static final String APP_VERSION_NAME_KEY = "appVersionName";
    static final String TIMESTAMP_KEY = "timestamp";
    static final String TYPE_KEY = "type";
    static final String DETAILS_KEY = "details";
    static final String CUSTOM_TYPE = "customType";
    static final String CUSTOM_ATTRIBUTES = "customAttributes";

    SessionEventTransform() {
    }

    public byte[] toBytes(SessionEvent event) throws IOException {
        return this.buildJsonForEvent(event).toString().getBytes("UTF-8");
    }

    @TargetApi(value=9)
    public JSONObject buildJsonForEvent(SessionEvent event) throws IOException {
        try {
            JSONObject jsonObject = new JSONObject();
            SessionEventMetadata sessionEventMetadata = event.sessionEventMetadata;
            jsonObject.put(APP_BUNDLE_ID_KEY, (Object)sessionEventMetadata.appBundleId);
            jsonObject.put(EXECUTION_ID_KEY, (Object)sessionEventMetadata.executionId);
            jsonObject.put(INSTALLATION_ID_KEY, (Object)sessionEventMetadata.installationId);
            jsonObject.put(ANDROID_ID_KEY, (Object)sessionEventMetadata.androidId);
            jsonObject.put(ADVERTISING_ID_KEY, (Object)sessionEventMetadata.advertisingId);
            jsonObject.put(BETA_DEVICE_TOKEN_KEY, (Object)sessionEventMetadata.betaDeviceToken);
            jsonObject.put(BUILD_ID_KEY, (Object)sessionEventMetadata.buildId);
            jsonObject.put(OS_VERSION_KEY, (Object)sessionEventMetadata.osVersion);
            jsonObject.put(DEVICE_MODEL_KEY, (Object)sessionEventMetadata.deviceModel);
            jsonObject.put(APP_VERSION_CODE_KEY, (Object)sessionEventMetadata.appVersionCode);
            jsonObject.put(APP_VERSION_NAME_KEY, (Object)sessionEventMetadata.appVersionName);
            jsonObject.put(TIMESTAMP_KEY, event.timestamp);
            jsonObject.put(TYPE_KEY, (Object)event.type.toString());
            jsonObject.put(DETAILS_KEY, (Object)new JSONObject(event.details));
            jsonObject.put(CUSTOM_TYPE, (Object)event.customType);
            jsonObject.put(CUSTOM_ATTRIBUTES, (Object)new JSONObject(event.customAttributes));
            return jsonObject;
        }
        catch (JSONException e) {
            if (Build.VERSION.SDK_INT >= 9) {
                throw new IOException(e.getMessage(), e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

