/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import com.crashlytics.android.answers.AnswersEventValidator;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class AnswersAttributes {
    final AnswersEventValidator validator;
    final Map<String, Object> attributes = new HashMap<String, Object>();

    public AnswersAttributes(AnswersEventValidator validator) {
        this.validator = validator;
    }

    void put(String key, String value) {
        if (this.validator.isNull(key, "key") || this.validator.isNull(value, "value")) {
            return;
        }
        key = this.validator.limitStringLength(key);
        value = this.validator.limitStringLength(value);
        this.putAttribute(key, value);
    }

    void put(String key, Number value) {
        if (this.validator.isNull(key, "key") || this.validator.isNull(value, "value")) {
            return;
        }
        key = this.validator.limitStringLength(key);
        this.putAttribute(key, value);
    }

    void putAttribute(String key, Object value) {
        if (!this.validator.isFullMap(this.attributes, key)) {
            this.attributes.put(key, value);
        }
    }

    public String toString() {
        return new JSONObject(this.attributes).toString();
    }
}

