/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.annotation.SuppressLint;
import android.content.Context;
import com.crashlytics.android.beta.Beta;
import com.crashlytics.android.beta.BuildProperties;
import com.crashlytics.android.beta.CheckForUpdatesRequest;
import com.crashlytics.android.beta.CheckForUpdatesResponseTransform;
import com.crashlytics.android.beta.UpdatesController;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.settings.BetaSettingsData;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractCheckForUpdatesController
implements UpdatesController {
    static final String LAST_UPDATE_CHECK_KEY = "last_update_check";
    static final long LAST_UPDATE_CHECK_DEFAULT = 0L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean externallyReady;
    private Context context;
    private Beta beta;
    private IdManager idManager;
    private BetaSettingsData betaSettings;
    private BuildProperties buildProps;
    private PreferenceStore preferenceStore;
    private CurrentTimeProvider currentTimeProvider;
    private HttpRequestFactory httpRequestFactory;
    private long lastCheckTimeMillis = 0L;

    public AbstractCheckForUpdatesController() {
        this(false);
    }

    public AbstractCheckForUpdatesController(boolean externallyReady) {
        this.externallyReady = new AtomicBoolean(externallyReady);
    }

    @Override
    public void initialize(Context context, Beta beta, IdManager idManager, BetaSettingsData betaSettings, BuildProperties buildProps, PreferenceStore preferenceStore, CurrentTimeProvider currentTimeProvider, HttpRequestFactory httpRequestFactory) {
        this.context = context;
        this.beta = beta;
        this.idManager = idManager;
        this.betaSettings = betaSettings;
        this.buildProps = buildProps;
        this.preferenceStore = preferenceStore;
        this.currentTimeProvider = currentTimeProvider;
        this.httpRequestFactory = httpRequestFactory;
        if (this.signalInitialized()) {
            this.checkForUpdates();
        }
    }

    protected boolean signalExternallyReady() {
        this.externallyReady.set(true);
        return this.initialized.get();
    }

    boolean signalInitialized() {
        this.initialized.set(true);
        return this.externallyReady.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    protected void checkForUpdates() {
        PreferenceStore preferenceStore = this.preferenceStore;
        synchronized (preferenceStore) {
            if (this.preferenceStore.get().contains(LAST_UPDATE_CHECK_KEY)) {
                this.preferenceStore.save(this.preferenceStore.edit().remove(LAST_UPDATE_CHECK_KEY));
            }
        }
        long currentTimeMillis = this.currentTimeProvider.getCurrentTimeMillis();
        long updateCheckDelayMillis = (long)this.betaSettings.updateSuspendDurationSeconds * 1000L;
        Fabric.getLogger().d("Beta", "Check for updates delay: " + updateCheckDelayMillis);
        Fabric.getLogger().d("Beta", "Check for updates last check time: " + this.getLastCheckTimeMillis());
        long nextCheckTimeMillis = this.getLastCheckTimeMillis() + updateCheckDelayMillis;
        Fabric.getLogger().d("Beta", "Check for updates current time: " + currentTimeMillis + ", next check time: " + nextCheckTimeMillis);
        if (currentTimeMillis >= nextCheckTimeMillis) {
            try {
                this.performUpdateCheck();
            }
            finally {
                this.setLastCheckTimeMillis(currentTimeMillis);
            }
        } else {
            Fabric.getLogger().d("Beta", "Check for updates next check time was not passed");
        }
    }

    private void performUpdateCheck() {
        Fabric.getLogger().d("Beta", "Performing update check");
        String apiKey = new ApiKey().getValue(this.context);
        String idHeaderValue = this.idManager.createIdHeaderValue(apiKey, this.buildProps.packageName);
        CheckForUpdatesRequest request = new CheckForUpdatesRequest(this.beta, this.beta.getOverridenSpiEndpoint(), this.betaSettings.updateUrl, this.httpRequestFactory, new CheckForUpdatesResponseTransform());
        request.invoke(apiKey, idHeaderValue, this.buildProps);
    }

    void setLastCheckTimeMillis(long time) {
        this.lastCheckTimeMillis = time;
    }

    long getLastCheckTimeMillis() {
        return this.lastCheckTimeMillis;
    }
}

