/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import android.os.Bundle;
import com.crashlytics.android.core.AppMeasurementEventListenerRegistrar;
import com.crashlytics.android.core.CrashlyticsCore;
import io.fabric.sdk.android.Fabric;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class DefaultAppMeasurementEventListenerRegistrar
implements AppMeasurementEventListenerRegistrar {
    private static final String CRASH_ORIGIN = "crash";
    private static final String ANALYTIC_CLASS = "com.google.android.gms.measurement.AppMeasurement";
    private static final String ANALYTIC_CLASS_ON_EVENT_LISTENER = "com.google.android.gms.measurement.AppMeasurement$OnEventListener";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String REGISTER_METHOD = "registerOnMeasurementEventListener";
    private static final String NAME = "name";
    private static final String PARAMETERS = "parameters";
    private static final String METHOD_EQUALS = "equals";
    private static final String METHOD_TOSTRING = "toString";
    private static final String METHOD_HASHCODE = "hashCode";
    private static final String METHOD_ONEVENT = "onEvent";
    private static final List<Class<?>> ONEVENT_EXPECTED_ARGTYPES = Collections.unmodifiableList(Arrays.asList(String.class, String.class, Bundle.class, Long.class));
    private static final String ERROR_PREFIX = "Cannot register AppMeasurement Listener for Crashlytics breadcrumbs: ";
    private final CrashlyticsCore crashlyticsCore;
    private Object eventListenerProxy;

    public DefaultAppMeasurementEventListenerRegistrar(CrashlyticsCore crashlyticsCore) {
        this.crashlyticsCore = crashlyticsCore;
    }

    @Override
    public boolean register() {
        Class<?> appMeasurementClass = this.getClass(ANALYTIC_CLASS);
        if (appMeasurementClass == null) {
            Fabric.getLogger().d("CrashlyticsCore", "Firebase Analytics is not present; you will not see automatic logging of events before a crash occurs.");
            return false;
        }
        Object appMeasurementInstance = this.getInstance(appMeasurementClass);
        if (appMeasurementInstance == null) {
            Fabric.getLogger().w("CrashlyticsCore", "Cannot register AppMeasurement Listener for Crashlytics breadcrumbs: Could not create an instance of Firebase Analytics.");
            return false;
        }
        Class<?> onEventListenerClass = this.getClass(ANALYTIC_CLASS_ON_EVENT_LISTENER);
        if (onEventListenerClass == null) {
            Fabric.getLogger().w("CrashlyticsCore", "Cannot register AppMeasurement Listener for Crashlytics breadcrumbs: Could not get class com.google.android.gms.measurement.AppMeasurement$OnEventListener");
            return false;
        }
        try {
            Method registrationMethod = appMeasurementClass.getDeclaredMethod(REGISTER_METHOD, onEventListenerClass);
            registrationMethod.invoke(appMeasurementInstance, this.getOnEventListenerProxy(onEventListenerClass));
        }
        catch (NoSuchMethodException e) {
            Fabric.getLogger().w("CrashlyticsCore", "Cannot register AppMeasurement Listener for Crashlytics breadcrumbs: Method registerOnMeasurementEventListener not found.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            Fabric.getLogger().w("CrashlyticsCore", ERROR_PREFIX + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private Class<?> getClass(String clazz) {
        try {
            return this.crashlyticsCore.getContext().getClassLoader().loadClass(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getInstance(Class<?> instanceClass) {
        try {
            Method getInstanceMethod = instanceClass.getDeclaredMethod(GET_INSTANCE_METHOD, Context.class);
            return getInstanceMethod.invoke(instanceClass, this.crashlyticsCore.getContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    synchronized Object getOnEventListenerProxy(Class appMeasurementEventListenerClass) {
        if (this.eventListenerProxy == null) {
            this.eventListenerProxy = Proxy.newProxyInstance(this.crashlyticsCore.getContext().getClassLoader(), new Class[]{appMeasurementEventListenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    String methodName = method.getName();
                    if (args == null) {
                        args = new Object[]{};
                    }
                    if (args.length == 1 && methodName.equals(DefaultAppMeasurementEventListenerRegistrar.METHOD_EQUALS)) {
                        return this.equalsImpl(proxy, args[0]);
                    }
                    if (args.length == 0 && methodName.equals(DefaultAppMeasurementEventListenerRegistrar.METHOD_HASHCODE)) {
                        return super.hashCode();
                    }
                    if (args.length == 0 && methodName.equals(DefaultAppMeasurementEventListenerRegistrar.METHOD_TOSTRING)) {
                        return super.toString();
                    }
                    if (args.length == 4 && methodName.equals(DefaultAppMeasurementEventListenerRegistrar.METHOD_ONEVENT) && DefaultAppMeasurementEventListenerRegistrar.validateOnEventArgTypes(args)) {
                        String origin = (String)args[0];
                        String name = (String)args[1];
                        Bundle params = (Bundle)args[2];
                        if (origin != null && !origin.equals(DefaultAppMeasurementEventListenerRegistrar.CRASH_ORIGIN)) {
                            DefaultAppMeasurementEventListenerRegistrar.writeEventToUserLog(DefaultAppMeasurementEventListenerRegistrar.this.crashlyticsCore, name, params);
                            return null;
                        }
                    }
                    StringBuilder error = new StringBuilder("Unexpected method invoked on AppMeasurement.EventListener: " + methodName + "(");
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            error.append(", ");
                        }
                        error.append(args[i].getClass().getName());
                    }
                    error.append("); returning null");
                    Fabric.getLogger().e("CrashlyticsCore", error.toString());
                    return null;
                }

                public boolean equalsImpl(Object proxy, Object obj) {
                    if (proxy == obj) {
                        return true;
                    }
                    return obj != null && Proxy.isProxyClass(obj.getClass()) && super.equals(Proxy.getInvocationHandler(obj));
                }
            });
        }
        return this.eventListenerProxy;
    }

    static boolean validateOnEventArgTypes(Object[] args) {
        if (args.length != ONEVENT_EXPECTED_ARGTYPES.size()) {
            return false;
        }
        Iterator<Class<?>> typeItr = ONEVENT_EXPECTED_ARGTYPES.iterator();
        for (Object arg : args) {
            if (arg.getClass().equals(typeItr.next())) continue;
            return false;
        }
        return true;
    }

    private static void writeEventToUserLog(CrashlyticsCore crashlyticsCore, String name, Bundle params) {
        try {
            crashlyticsCore.log("$A$:" + DefaultAppMeasurementEventListenerRegistrar.serializeEvent(name, params));
        }
        catch (JSONException e) {
            Fabric.getLogger().w("CrashlyticsCore", "Unable to serialize Firebase Analytics event; " + name);
        }
    }

    private static String serializeEvent(String name, Bundle params) throws JSONException {
        JSONObject enclosingObject = new JSONObject();
        JSONObject paramsObject = new JSONObject();
        for (String key : params.keySet()) {
            paramsObject.put(key, params.get(key));
        }
        enclosingObject.put(NAME, (Object)name);
        enclosingObject.put(PARAMETERS, (Object)paramsObject);
        return enclosingObject.toString();
    }
}

