/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.util.concurrent.atomic.AtomicBoolean;

class DevicePowerStateListener {
    private static final IntentFilter FILTER_BATTERY_CHANGED = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private static final IntentFilter FILTER_POWER_CONNECTED = new IntentFilter("android.intent.action.ACTION_POWER_CONNECTED");
    private static final IntentFilter FILTER_POWER_DISCONNECTED = new IntentFilter("android.intent.action.ACTION_POWER_DISCONNECTED");
    private final AtomicBoolean receiversRegistered;
    private final Context context;
    private final BroadcastReceiver powerDisconnectedReceiver;
    private final BroadcastReceiver powerConnectedReceiver;
    private boolean isPowerConnected;

    public DevicePowerStateListener(Context context) {
        this.context = context;
        this.powerConnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                DevicePowerStateListener.this.isPowerConnected = true;
            }
        };
        this.powerDisconnectedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                DevicePowerStateListener.this.isPowerConnected = false;
            }
        };
        this.receiversRegistered = new AtomicBoolean(false);
    }

    public void initialize() {
        if (this.receiversRegistered.getAndSet(true)) {
            return;
        }
        Intent statusIntent = this.context.registerReceiver(null, FILTER_BATTERY_CHANGED);
        int status = statusIntent != null ? statusIntent.getIntExtra("status", -1) : -1;
        this.isPowerConnected = status == 2 || status == 5;
        this.context.registerReceiver(this.powerConnectedReceiver, FILTER_POWER_CONNECTED);
        this.context.registerReceiver(this.powerDisconnectedReceiver, FILTER_POWER_DISCONNECTED);
    }

    public boolean isPowerConnected() {
        return this.isPowerConnected;
    }

    public void dispose() {
        if (!this.receiversRegistered.getAndSet(false)) {
            return;
        }
        this.context.unregisterReceiver(this.powerConnectedReceiver);
        this.context.unregisterReceiver(this.powerDisconnectedReceiver);
    }
}

