/*
 * Decompiled with CFR 0.152.
 */
package shadeio.commons.compress.harmony.unpack200.bytecode.forms;

import java.util.Arrays;
import shadeio.commons.compress.harmony.unpack200.bytecode.ByteCode;
import shadeio.commons.compress.harmony.unpack200.bytecode.OperandManager;
import shadeio.commons.compress.harmony.unpack200.bytecode.forms.SwitchForm;

public class LookupSwitchForm
extends SwitchForm {
    public LookupSwitchForm(int opcode, String name) {
        super(opcode, name);
    }

    @Override
    public void setByteCodeOperands(ByteCode byteCode, OperandManager operandManager, int codeLength) {
        int case_count = operandManager.nextCaseCount();
        int default_pc = operandManager.nextLabel();
        int[] case_values = new int[case_count];
        Arrays.setAll(case_values, i -> operandManager.nextCaseValues());
        int[] case_pcs = new int[case_count];
        Arrays.setAll(case_pcs, i -> operandManager.nextLabel());
        int[] labelsArray = new int[case_count + 1];
        labelsArray[0] = default_pc;
        System.arraycopy(case_pcs, 0, labelsArray, 1, case_count + 1 - 1);
        byteCode.setByteCodeTargets(labelsArray);
        int padLength = 3 - codeLength % 4;
        int rewriteSize = 1 + padLength + 4 + 4 + 4 * case_values.length + 4 * case_pcs.length;
        int[] newRewrite = new int[rewriteSize];
        int rewriteIndex = 0;
        newRewrite[rewriteIndex++] = byteCode.getOpcode();
        for (int index = 0; index < padLength; ++index) {
            newRewrite[rewriteIndex++] = 0;
        }
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        int npairsIndex = rewriteIndex;
        this.setRewrite4Bytes(case_values.length, npairsIndex, newRewrite);
        rewriteIndex += 4;
        for (int case_value : case_values) {
            this.setRewrite4Bytes(case_value, rewriteIndex, newRewrite);
            rewriteIndex += 4;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
        }
        byteCode.setRewrite(newRewrite);
    }
}

