/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.dvcs;

import com.databricks.internal.bouncycastle.asn1.dvcs.CertEtcToken;
import com.databricks.internal.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import com.databricks.internal.bouncycastle.asn1.dvcs.DVCSTime;
import com.databricks.internal.bouncycastle.asn1.dvcs.Data;
import com.databricks.internal.bouncycastle.asn1.dvcs.ServiceType;
import com.databricks.internal.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.databricks.internal.bouncycastle.asn1.x509.Extension;
import com.databricks.internal.bouncycastle.cert.X509CertificateHolder;
import com.databricks.internal.bouncycastle.dvcs.DVCSException;
import com.databricks.internal.bouncycastle.dvcs.DVCSRequest;
import com.databricks.internal.bouncycastle.dvcs.DVCSRequestBuilder;
import com.databricks.internal.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

