/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.RequestValidationException;

public class ColumnMetadata {
    private static final String COLUMN_NAME = "column_name";
    private static final String VALIDATOR = "validator";
    private static final String INDEX = "component_index";
    private final TableMetadata table;
    private final String name;
    private final DataType type;
    private final IndexMetadata index;

    ColumnMetadata(TableMetadata table, String name, DataType type, Row row) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.index = IndexMetadata.build(this, row);
    }

    static ColumnMetadata build(TableMetadata tm, Row row) {
        try {
            String name = row.getString(COLUMN_NAME);
            AbstractType t = TypeParser.parse((String)row.getString(VALIDATOR));
            ColumnMetadata cm = new ColumnMetadata(tm, name, Codec.rawTypeToDataType(t), row);
            tm.add(cm);
            return cm;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public DataType getType() {
        return this.type;
    }

    public IndexMetadata getIndex() {
        return this.index;
    }

    public String toString() {
        return this.name + " " + this.type;
    }

    public static class IndexMetadata {
        private static final String INDEX_TYPE = "index_type";
        private static final String INDEX_OPTIONS = "index_options";
        private static final String INDEX_NAME = "index_name";
        private final ColumnMetadata column;
        private final String name;
        private final String type;
        private final Map<String, String> options = new HashMap<String, String>();

        private IndexMetadata(ColumnMetadata column, String name, String type) {
            this.column = column;
            this.name = name;
            this.type = type;
        }

        public ColumnMetadata getIndexedColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public String asCQLQuery() {
            TableMetadata table = this.column.getTable();
            return String.format("CREATE INDEX %s ON %s.%s (%s)", this.name, table.getKeyspace().getName(), table.getName(), this.column.getName());
        }

        private static IndexMetadata build(ColumnMetadata column, Row row) {
            if (row == null) {
                return null;
            }
            String type = row.getString(INDEX_TYPE);
            if (type == null) {
                return null;
            }
            IndexMetadata index = new IndexMetadata(column, type, row.getString(INDEX_NAME));
            return index;
        }
    }
}

