/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.Session;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.JmxReporter;
import java.util.HashSet;

public class Metrics {
    private final Cluster.Manager manager;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final JmxReporter jmxReporter = new JmxReporter(this.registry);
    private final Errors errors = new Errors();
    private final Timer requests = this.registry.newTimer(Metrics.class, "requests");
    private final Gauge<Integer> knownHosts = this.registry.newGauge(Metrics.class, "known-hosts", (Gauge)new Gauge<Integer>(){

        public Integer value() {
            return ((Metrics)Metrics.this).manager.metadata.allHosts().size();
        }
    });
    private final Gauge<Integer> connectedTo = this.registry.newGauge(Metrics.class, "connected-to", (Gauge)new Gauge<Integer>(){

        public Integer value() {
            HashSet s = new HashSet();
            for (Session session : ((Metrics)Metrics.this).manager.sessions) {
                s.addAll(session.manager.pools.keySet());
            }
            return s.size();
        }
    });
    private final Gauge<Integer> openConnections = this.registry.newGauge(Metrics.class, "open-connections", (Gauge)new Gauge<Integer>(){

        public Integer value() {
            int value = ((Metrics)Metrics.this).manager.controlConnection.isOpen() ? 1 : 0;
            for (Session session : ((Metrics)Metrics.this).manager.sessions) {
                for (HostConnectionPool pool : session.manager.pools.values()) {
                    value += pool.opened();
                }
            }
            return value;
        }
    });

    Metrics(Cluster.Manager manager) {
        this.manager = manager;
        this.jmxReporter.start();
    }

    public MetricsRegistry getRegistry() {
        return this.registry;
    }

    public Timer getRequestsTimer() {
        return this.requests;
    }

    public Errors getErrorMetrics() {
        return this.errors;
    }

    public Gauge<Integer> getKnownHosts() {
        return this.knownHosts;
    }

    public Gauge<Integer> getConnectedToHosts() {
        return this.connectedTo;
    }

    public Gauge<Integer> getOpenConnections() {
        return this.openConnections;
    }

    void shutdown() {
        this.jmxReporter.shutdown();
    }

    public class Errors {
        private final Counter connectionErrors;
        private final Counter writeTimeouts;
        private final Counter readTimeouts;
        private final Counter unavailables;
        private final Counter otherErrors;
        private final Counter retries;
        private final Counter ignores;

        public Errors() {
            this.connectionErrors = Metrics.this.registry.newCounter(Errors.class, "connection-errors");
            this.writeTimeouts = Metrics.this.registry.newCounter(Errors.class, "write-timeouts");
            this.readTimeouts = Metrics.this.registry.newCounter(Errors.class, "read-timeouts");
            this.unavailables = Metrics.this.registry.newCounter(Errors.class, "unavailables");
            this.otherErrors = Metrics.this.registry.newCounter(Errors.class, "other-errors");
            this.retries = Metrics.this.registry.newCounter(Errors.class, "retries");
            this.ignores = Metrics.this.registry.newCounter(Errors.class, "ignores");
        }

        public Counter getConnectionErrors() {
            return this.connectionErrors;
        }

        public Counter getWriteTimeouts() {
            return this.writeTimeouts;
        }

        public Counter getReadTimeouts() {
            return this.readTimeouts;
        }

        public Counter getUnavailables() {
            return this.unavailables;
        }

        public Counter getOthers() {
            return this.otherErrors;
        }

        public Counter getRetries() {
            return this.retries;
        }

        public Counter getIgnores() {
            return this.ignores;
        }
    }
}

