/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public abstract class Assignment
extends Utils.Appendeable {
    protected final String name;

    private Assignment(String name) {
        this.name = name;
    }

    static class MapPutAssignment
    extends Assignment {
        private final Object key;
        private final Object value;

        MapPutAssignment(String name, Object key, Object value) {
            super(name);
            this.key = key;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append("[");
            Utils.appendValue(this.key, sb);
            sb.append("]=");
            Utils.appendValue(this.value, sb);
        }
    }

    static class CollectionAssignment
    extends Assignment {
        private final Object collection;
        private final boolean isAdd;

        CollectionAssignment(String name, Object collection, boolean isAdd) {
            super(name);
            this.collection = collection;
            this.isAdd = isAdd;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isAdd ? "+" : "-");
            Utils.appendCollection(this.collection, sb);
        }
    }

    static class ListSetIdxAssignment
    extends Assignment {
        private final int idx;
        private final Object value;

        ListSetIdxAssignment(String name, int idx, Object value) {
            super(name);
            this.idx = idx;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append("[").append(this.idx).append("]=");
            Utils.appendValue(this.value, sb);
        }
    }

    static class ListPrependAssignment
    extends Assignment {
        private final List<?> value;

        ListPrependAssignment(String name, List<?> value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendList(this.value, sb);
            sb.append("+");
            Utils.appendName(this.name, sb);
        }
    }

    static class CounterAssignment
    extends Assignment {
        private final long value;
        private final boolean isIncr;

        CounterAssignment(String name, long value, boolean isIncr) {
            super(name);
            if (!isIncr && value < 0L) {
                this.value = -value;
                this.isIncr = true;
            } else {
                this.value = value;
                this.isIncr = isIncr;
            }
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isIncr ? "+" : "-").append(this.value);
        }
    }

    static class SetAssignment
    extends Assignment {
        private final Object value;

        SetAssignment(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb);
            sb.append("=");
            Utils.appendValue(this.value, sb);
        }
    }
}

