/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;

public class PreparedStatement {
    final ColumnDefinitions metadata;
    final MD5Digest id;
    final String query;
    final String queryKeyspace;
    volatile ByteBuffer routingKey;
    final int[] routingKeyIndexes;
    volatile ConsistencyLevel consistency;

    private PreparedStatement(ColumnDefinitions metadata, MD5Digest id, int[] routingKeyIndexes, String query, String queryKeyspace) {
        this.metadata = metadata;
        this.id = id;
        this.routingKeyIndexes = routingKeyIndexes;
        this.query = query;
        this.queryKeyspace = queryKeyspace;
    }

    static PreparedStatement fromMessage(ResultMessage.Prepared msg, Metadata clusterMetadata, String query, String queryKeyspace) {
        switch (msg.kind) {
            case PREPARED: {
                TableMetadata tm;
                ResultMessage.Prepared pmsg = msg;
                ColumnDefinitions.Definition[] defs = new ColumnDefinitions.Definition[pmsg.metadata.names.size()];
                if (defs.length == 0) {
                    return new PreparedStatement(new ColumnDefinitions(defs), pmsg.statementId, null, query, queryKeyspace);
                }
                List<ColumnMetadata> partitionKeyColumns = null;
                int[] pkIndexes = null;
                KeyspaceMetadata km = clusterMetadata.getKeyspace(((ColumnSpecification)pmsg.metadata.names.get((int)0)).ksName);
                if (km != null && (tm = km.getTable(((ColumnSpecification)pmsg.metadata.names.get((int)0)).cfName)) != null) {
                    partitionKeyColumns = tm.getPartitionKey();
                    pkIndexes = new int[partitionKeyColumns.size()];
                    for (int i = 0; i < pkIndexes.length; ++i) {
                        pkIndexes[i] = -1;
                    }
                }
                for (int i = 0; i < defs.length; ++i) {
                    defs[i] = ColumnDefinitions.Definition.fromTransportSpecification((ColumnSpecification)pmsg.metadata.names.get(i));
                    PreparedStatement.maybeGetIndex(defs[i].getName(), i, partitionKeyColumns, pkIndexes);
                }
                return new PreparedStatement(new ColumnDefinitions(defs), pmsg.statementId, PreparedStatement.allSet(pkIndexes) ? pkIndexes : null, query, queryKeyspace);
            }
        }
        throw new DriverInternalError(String.format("%s response received when prepared statement received was expected", msg.kind));
    }

    private static void maybeGetIndex(String name, int j, List<ColumnMetadata> pkColumns, int[] pkIndexes) {
        if (pkColumns == null) {
            return;
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            if (!name.equals(pkColumns.get(i).getName())) continue;
            pkIndexes[i] = j;
            return;
        }
    }

    private static boolean allSet(int[] pkColumns) {
        if (pkColumns == null) {
            return false;
        }
        for (int i = 0; i < pkColumns.length; ++i) {
            if (pkColumns[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public ColumnDefinitions getVariables() {
        return this.metadata;
    }

    public BoundStatement bind(Object ... values) {
        BoundStatement bs = new BoundStatement(this);
        return bs.bind(values);
    }

    public PreparedStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public PreparedStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    public PreparedStatement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getQueryKeyspace() {
        return this.queryKeyspace;
    }
}

