/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class WhiteListPolicy
implements LoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private final Set<InetAddress> whiteList;

    public WhiteListPolicy(LoadBalancingPolicy childPolicy, Collection<InetAddress> whiteList) {
        this.childPolicy = childPolicy;
        this.whiteList = ImmutableSet.copyOf(whiteList);
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        ArrayList<Host> whiteHosts = new ArrayList<Host>(hosts.size());
        for (Host host : hosts) {
            if (!this.whiteList.contains(host.getAddress())) continue;
            whiteHosts.add(host);
        }
        if (whiteHosts.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot use WhiteListPolicy where the white list (%s) contains none of the contacts points (%s)", this.whiteList, hosts));
        }
        this.childPolicy.init(cluster, whiteHosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.whiteList.contains(host.getAddress()) ? this.childPolicy.distance(host) : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(Query query) {
        return this.childPolicy.newQueryPlan(query);
    }

    @Override
    public void onUp(Host host) {
        if (this.whiteList.contains(host.getAddress())) {
            this.childPolicy.onUp(host);
        }
    }

    @Override
    public void onDown(Host host) {
        if (this.whiteList.contains(host.getAddress())) {
            this.childPolicy.onDown(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        if (this.whiteList.contains(host.getAddress())) {
            this.childPolicy.onAdd(host);
        }
    }

    @Override
    public void onRemove(Host host) {
        if (this.whiteList.contains(host.getAddress())) {
            this.childPolicy.onRemove(host);
        }
    }
}

