/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.netty.handler.ipfilter;

import com.datastax.oss.driver.shaded.netty.channel.ChannelHandler;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import com.datastax.oss.driver.shaded.netty.handler.ipfilter.IpFilterRule;
import com.datastax.oss.driver.shaded.netty.handler.ipfilter.IpFilterRuleType;
import com.datastax.oss.driver.shaded.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

