/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.util.Loggers;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MultiplexingNodeStateListener
implements NodeStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplexingNodeStateListener.class);
    private final List<NodeStateListener> listeners = new CopyOnWriteArrayList<NodeStateListener>();

    public MultiplexingNodeStateListener() {
    }

    public MultiplexingNodeStateListener(NodeStateListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public MultiplexingNodeStateListener(Collection<NodeStateListener> listeners) {
        this.addListeners(listeners);
    }

    private void addListeners(Collection<NodeStateListener> source) {
        for (NodeStateListener listener : source) {
            this.addListener(listener);
        }
    }

    private void addListener(NodeStateListener toAdd) {
        Objects.requireNonNull(toAdd, "listener cannot be null");
        if (toAdd instanceof MultiplexingNodeStateListener) {
            this.addListeners(((MultiplexingNodeStateListener)toAdd).listeners);
        } else {
            this.listeners.add(toAdd);
        }
    }

    public void register(@NonNull NodeStateListener listener) {
        this.addListener(listener);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        this.invokeListeners(listener -> listener.onAdd(node), "onAdd");
    }

    @Override
    public void onUp(@NonNull Node node) {
        this.invokeListeners(listener -> listener.onUp(node), "onUp");
    }

    @Override
    public void onDown(@NonNull Node node) {
        this.invokeListeners(listener -> listener.onDown(node), "onDown");
    }

    @Override
    public void onRemove(@NonNull Node node) {
        this.invokeListeners(listener -> listener.onRemove(node), "onRemove");
    }

    @Override
    public void onSessionReady(@NonNull Session session) {
        this.invokeListeners(listener -> listener.onSessionReady(session), "onSessionReady");
    }

    @Override
    public void close() throws Exception {
        for (NodeStateListener listener : this.listeners) {
            try {
                listener.close();
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Unexpected error while closing node state listener {}.", listener, e);
            }
        }
    }

    private void invokeListeners(@NonNull Consumer<NodeStateListener> action, String event) {
        for (NodeStateListener listener : this.listeners) {
            try {
                action.accept(listener);
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Unexpected error while notifying node state listener {} of an {} event.", listener, event, e);
            }
        }
    }
}

