/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.dse.protocol.internal.request.RawBytesQuery;
import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;

public class GraphConversions
extends Conversions {
    static final String GRAPH_LANG_OPTION_KEY = "graph-language";
    static final String GRAPH_NAME_OPTION_KEY = "graph-name";
    static final String GRAPH_SOURCE_OPTION_KEY = "graph-source";
    static final String GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY = "graph-read-consistency";
    static final String GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY = "graph-write-consistency";
    static final String GRAPH_RESULTS_OPTION_KEY = "graph-results";
    static final String GRAPH_TIMEOUT_OPTION_KEY = "request-timeout";
    static final String GRAPH_BINARY_QUERY_OPTION_KEY = "graph-binary-query";
    static final String LANGUAGE_GROOVY = "gremlin-groovy";
    static final String LANGUAGE_BYTECODE = "bytecode-json";
    private static final BufferFactory<ByteBuf> FACTORY = new DseNettyBufferFactory();
    @VisibleForTesting
    static final byte[] EMPTY_STRING_QUERY = "".getBytes(StandardCharsets.UTF_8);

    public static Message createContinuousMessageFromGraphStatement(GraphStatement<?> statement, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        List<Object> encodedQueryParams;
        if (!(statement instanceof ScriptGraphStatement) || ((ScriptGraphStatement)statement).getQueryParams().isEmpty()) {
            encodedQueryParams = Collections.emptyList();
        } else {
            try {
                Map<String, Object> queryParams = ((ScriptGraphStatement)statement).getQueryParams();
                if (subProtocol.isGraphBinary()) {
                    Buffer graphBinaryParams = graphBinaryModule.serialize(queryParams);
                    encodedQueryParams = Collections.singletonList(graphBinaryParams.nioBuffer());
                    graphBinaryParams.release();
                } else {
                    encodedQueryParams = Collections.singletonList(GraphSONUtils.serializeToByteBuffer(queryParams, subProtocol));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't serialize parameters for GraphStatement: " + statement, e);
            }
        }
        int consistencyLevel = DefaultConsistencyLevel.valueOf(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode();
        long timestamp = statement.getTimestamp();
        if (timestamp == Long.MIN_VALUE) {
            timestamp = context.getTimestampGenerator().next();
        }
        int pageSize = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_PAGE_SIZE);
        int maxPages = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES);
        int maxPagesPerSecond = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND);
        int maxEnqueuedPages = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
        ContinuousPagingOptions options = new ContinuousPagingOptions(maxPages, maxPagesPerSecond, maxEnqueuedPages);
        DseQueryOptions queryOptions = new DseQueryOptions(consistencyLevel, encodedQueryParams, Collections.emptyMap(), true, pageSize, null, 9, timestamp, null, false, options);
        if (statement instanceof ScriptGraphStatement) {
            return new Query(((ScriptGraphStatement)statement).getScript(), (QueryOptions)queryOptions);
        }
        return new RawBytesQuery(GraphConversions.getQueryBytes(statement, subProtocol), queryOptions);
    }

    static Message createMessageFromGraphStatement(GraphStatement<?> statement, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        List<Object> encodedQueryParams;
        if (!(statement instanceof ScriptGraphStatement) || ((ScriptGraphStatement)statement).getQueryParams().isEmpty()) {
            encodedQueryParams = Collections.emptyList();
        } else {
            try {
                Map<String, Object> queryParams = ((ScriptGraphStatement)statement).getQueryParams();
                if (subProtocol.isGraphBinary()) {
                    Buffer graphBinaryParams = graphBinaryModule.serialize(queryParams);
                    encodedQueryParams = Collections.singletonList(graphBinaryParams.nioBuffer());
                    graphBinaryParams.release();
                } else {
                    encodedQueryParams = Collections.singletonList(GraphSONUtils.serializeToByteBuffer(queryParams, subProtocol));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't serialize parameters for GraphStatement: " + statement, e);
            }
        }
        int consistencyLevel = DefaultConsistencyLevel.valueOf(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode();
        long timestamp = statement.getTimestamp();
        if (timestamp == Long.MIN_VALUE) {
            timestamp = context.getTimestampGenerator().next();
        }
        DseQueryOptions queryOptions = new DseQueryOptions(consistencyLevel, encodedQueryParams, Collections.emptyMap(), true, 50, null, 9, timestamp, null, false, null);
        if (statement instanceof ScriptGraphStatement) {
            return new Query(((ScriptGraphStatement)statement).getScript(), (QueryOptions)queryOptions);
        }
        return new RawBytesQuery(GraphConversions.getQueryBytes(statement, subProtocol), queryOptions);
    }

    @VisibleForTesting
    public static Object bytecodeToSerialize(GraphStatement<?> statement) {
        Preconditions.checkArgument((statement instanceof FluentGraphStatement || statement instanceof BatchGraphStatement || statement instanceof BytecodeGraphStatement ? 1 : 0) != 0, (String)"To serialize bytecode the query must be a fluent or batch statement, but was: %s", statement.getClass());
        Object toSerialize = statement instanceof FluentGraphStatement ? ((FluentGraphStatement)statement).getTraversal().asAdmin().getBytecode() : (statement instanceof BatchGraphStatement ? ImmutableList.copyOf((Iterator)Iterators.transform(((BatchGraphStatement)statement).iterator(), traversal -> traversal.asAdmin().getBytecode())) : ((BytecodeGraphStatement)statement).getBytecode());
        return toSerialize;
    }

    private static byte[] getQueryBytes(GraphStatement<?> statement, GraphProtocol graphSubProtocol) {
        try {
            return graphSubProtocol.isGraphBinary() ? EMPTY_STRING_QUERY : GraphSONUtils.serializeToBytes(GraphConversions.bytecodeToSerialize(statement), graphSubProtocol);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Map<String, ByteBuffer> createCustomPayload(GraphStatement<?> statement, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        ByteBuffer payloadInitialProtocol;
        String graphLanguage;
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        NullAllowingImmutableMap.Builder payload = NullAllowingImmutableMap.builder();
        Map<String, ByteBuffer> statementOptions = statement.getCustomPayload();
        payload.putAll(statementOptions);
        if (!statementOptions.containsKey(GRAPH_LANG_OPTION_KEY)) {
            graphLanguage = statement instanceof ScriptGraphStatement ? LANGUAGE_GROOVY : LANGUAGE_BYTECODE;
            payload.put((Object)GRAPH_LANG_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(graphLanguage, protocolVersion));
        } else {
            graphLanguage = TypeCodecs.TEXT.decode(statementOptions.get(GRAPH_LANG_OPTION_KEY), protocolVersion);
            Preconditions.checkNotNull((Object)graphLanguage, (Object)"A null value was set for the graph-language custom payload key.");
        }
        if (!GraphConversions.isSystemQuery(statement, config)) {
            if (!statementOptions.containsKey(GRAPH_NAME_OPTION_KEY)) {
                String graphName = statement.getGraphName();
                if (graphName == null) {
                    graphName = config.getString(DseDriverOption.GRAPH_NAME, null);
                }
                if (graphName != null) {
                    payload.put((Object)GRAPH_NAME_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(graphName, protocolVersion));
                }
            }
            if (!statementOptions.containsKey(GRAPH_SOURCE_OPTION_KEY)) {
                String traversalSource = statement.getTraversalSource();
                if (traversalSource == null) {
                    traversalSource = config.getString(DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
                }
                if (traversalSource != null) {
                    payload.put((Object)GRAPH_SOURCE_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(traversalSource, protocolVersion));
                }
            }
        }
        if ((payloadInitialProtocol = statementOptions.get(GRAPH_RESULTS_OPTION_KEY)) == null) {
            Preconditions.checkNotNull((Object)((Object)subProtocol));
            payload.put((Object)GRAPH_RESULTS_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(subProtocol.toInternalCode(), protocolVersion));
        } else {
            subProtocol = GraphProtocol.fromString(TypeCodecs.TEXT.decode(payloadInitialProtocol, protocolVersion));
        }
        if (subProtocol.isGraphBinary() && graphLanguage.equals(LANGUAGE_BYTECODE)) {
            Object bytecodeQuery = GraphConversions.bytecodeToSerialize(statement);
            try {
                Buffer bytecodeByteBuf = graphBinaryModule.serialize(bytecodeQuery);
                payload.put((Object)GRAPH_BINARY_QUERY_OPTION_KEY, (Object)bytecodeByteBuf.nioBuffer());
                bytecodeByteBuf.release();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (!statementOptions.containsKey(GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String readClString;
            ConsistencyLevel readCl = statement.getReadConsistencyLevel();
            String string = readClString = readCl != null ? readCl.name() : config.getString(DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null);
            if (readClString != null) {
                payload.put((Object)GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(readClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String writeClString;
            ConsistencyLevel writeCl = statement.getWriteConsistencyLevel();
            String string = writeClString = writeCl != null ? writeCl.name() : config.getString(DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null);
            if (writeClString != null) {
                payload.put((Object)GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY, (Object)TypeCodecs.TEXT.encode(writeClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_TIMEOUT_OPTION_KEY)) {
            Duration timeout = statement.getTimeout();
            if (timeout == null) {
                timeout = config.getDuration(DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO);
            }
            if (timeout != null && !timeout.isZero()) {
                payload.put((Object)GRAPH_TIMEOUT_OPTION_KEY, (Object)TypeCodecs.BIGINT.encode(timeout.toMillis(), protocolVersion));
            }
        }
        return payload.build();
    }

    private static boolean isSystemQuery(GraphStatement<?> statement, DriverExecutionProfile config) {
        Boolean statementValue;
        if (statement instanceof ScriptGraphStatement && (statementValue = ((ScriptGraphStatement)statement).isSystemQuery()) != null) {
            return statementValue;
        }
        return config.getBoolean(DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false);
    }

    public static GraphNode createGraphBinaryGraphNode(List<ByteBuffer> data, GraphBinaryModule graphBinaryModule) throws IOException {
        Preconditions.checkArgument((data.size() == 1 ? 1 : 0) != 0, (Object)"Invalid row given to deserialize");
        Buffer toDeserialize = FACTORY.wrap(data.get(0));
        Object deserializedObject = graphBinaryModule.deserialize(toDeserialize);
        toDeserialize.release();
        assert (deserializedObject instanceof Traverser) : "Graph protocol error. Received object should be a Traverser but it is not.";
        return new ObjectGraphNode(deserializedObject);
    }

    public static Duration resolveGraphRequestTimeout(GraphStatement<?> statement, InternalDriverContext context) {
        DriverExecutionProfile executionProfile = GraphConversions.resolveExecutionProfile(statement, context);
        return statement.getTimeout() != null ? statement.getTimeout() : executionProfile.getDuration(DseDriverOption.GRAPH_TIMEOUT);
    }

    public static GraphProtocol resolveGraphSubProtocol(GraphStatement<?> statement, GraphSupportChecker graphSupportChecker, InternalDriverContext context) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, context);
        return graphSupportChecker.inferGraphProtocol(statement, executionProfile, context);
    }
}

