/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousRequestHandlerBase;
import com.datastax.dse.driver.internal.core.graph.ContinuousAsyncGraphResultSet;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ContinuousGraphRequestHandler
extends ContinuousRequestHandlerBase<GraphStatement<?>, AsyncGraphResultSet> {
    private final Message message;
    private final GraphProtocol subProtocol;
    private final GraphBinaryModule graphBinaryModule;
    private final Duration globalTimeout;
    private final int maxEnqueuedPages;
    private final int maxPages;

    ContinuousGraphRequestHandler(@NonNull GraphStatement<?> statement, @NonNull DefaultSession session, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix, @NonNull GraphBinaryModule graphBinaryModule, @NonNull GraphSupportChecker graphSupportChecker) {
        super(statement, session, context, sessionLogPrefix, AsyncGraphResultSet.class, true, DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, DseSessionMetric.GRAPH_REQUESTS, DseNodeMetric.GRAPH_MESSAGES);
        this.graphBinaryModule = graphBinaryModule;
        this.subProtocol = graphSupportChecker.inferGraphProtocol(statement, this.executionProfile, context);
        this.message = GraphConversions.createContinuousMessageFromGraphStatement(statement, this.subProtocol, this.executionProfile, context, graphBinaryModule);
        this.globalTimeout = (Duration)MoreObjects.firstNonNull((Object)statement.getTimeout(), (Object)this.executionProfile.getDuration(DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO));
        this.maxEnqueuedPages = this.executionProfile.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
        this.maxPages = this.executionProfile.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES);
        this.throttler.register(this);
    }

    @Override
    @NonNull
    protected Duration getGlobalTimeout() {
        return this.globalTimeout;
    }

    @Override
    @NonNull
    protected Duration getPageTimeout(int pageNumber) {
        return Duration.ZERO;
    }

    @Override
    @NonNull
    protected Duration getReviseRequestTimeout() {
        return Duration.ZERO;
    }

    @Override
    protected int getMaxEnqueuedPages() {
        return this.maxEnqueuedPages;
    }

    @Override
    protected int getMaxPages() {
        return this.maxPages;
    }

    @Override
    @NonNull
    protected Message getMessage() {
        return this.message;
    }

    @Override
    protected boolean isTracingEnabled() {
        return ((GraphStatement)this.statement).isTracing();
    }

    @Override
    @NonNull
    protected Map<String, ByteBuffer> createPayload() {
        return GraphConversions.createCustomPayload((GraphStatement)this.statement, this.subProtocol, this.executionProfile, this.context, this.graphBinaryModule);
    }

    @Override
    @NonNull
    protected AsyncGraphResultSet createEmptyResultSet(@NonNull ExecutionInfo executionInfo) {
        return ContinuousAsyncGraphResultSet.empty(executionInfo);
    }

    @Override
    @NonNull
    protected ContinuousAsyncGraphResultSet createResultSet(@NonNull Rows rows, @NonNull ExecutionInfo executionInfo, @NonNull ColumnDefinitions columnDefinitions) throws IOException {
        ArrayDeque<GraphNode> graphNodes = new ArrayDeque<GraphNode>();
        for (List row : rows.getData()) {
            if (this.subProtocol.isGraphBinary()) {
                graphNodes.offer(GraphConversions.createGraphBinaryGraphNode(row, this.graphBinaryModule));
                continue;
            }
            graphNodes.offer(GraphSONUtils.createGraphNode(row, this.subProtocol));
        }
        DseRowsMetadata metadata = (DseRowsMetadata)rows.getMetadata();
        return new ContinuousAsyncGraphResultSet(executionInfo, graphNodes, metadata.continuousPageNumber, !metadata.isLastContinuousPage, this, this.subProtocol);
    }

    @Override
    protected int pageNumber(@NonNull AsyncGraphResultSet resultSet) {
        return ((ContinuousAsyncGraphResultSet)resultSet).pageNumber();
    }
}

