/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class MapBasedDriverExecutionProfile
implements DriverExecutionProfile {
    private static final Object NO_VALUE = new Object();
    private final String profileName;
    private final Map<DriverOption, Object> overrides;
    private final Map<DriverOption, Object> profile;
    private final Map<DriverOption, Object> defaultProfile;

    public MapBasedDriverExecutionProfile(Map<String, Map<DriverOption, Object>> optionsMap, String profileName) {
        this(profileName, Collections.emptyMap(), optionsMap.get(profileName), profileName.equals("default") ? Collections.emptyMap() : optionsMap.get("default"));
        Preconditions.checkArgument((boolean)optionsMap.containsKey(profileName), (String)"Unknown profile '%s'. Check your configuration.", (Object)profileName);
    }

    public MapBasedDriverExecutionProfile(String profileName, Map<DriverOption, Object> overrides, Map<DriverOption, Object> profile, Map<DriverOption, Object> defaultProfile) {
        this.profileName = profileName;
        this.overrides = overrides;
        this.profile = profile;
        this.defaultProfile = defaultProfile;
    }

    @Override
    @NonNull
    public String getName() {
        return this.profileName;
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option) {
        if (this.overrides.containsKey(option)) {
            return this.overrides.get(option) != NO_VALUE;
        }
        return this.profile.containsKey(option) || this.defaultProfile.containsKey(option);
    }

    @NonNull
    private <T> T get(@NonNull DriverOption option) {
        Object value = this.overrides.getOrDefault(option, this.profile.getOrDefault(option, this.defaultProfile.get(option)));
        if (value == null || value == NO_VALUE) {
            throw new IllegalArgumentException("Missing configuration option " + option.getPath());
        }
        return (T)value;
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option) {
        return (Boolean)this.get(option);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public int getInt(@NonNull DriverOption option) {
        return (Integer)this.get(option);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public long getLong(@NonNull DriverOption option) {
        return (Long)this.get(option);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    public double getDouble(@NonNull DriverOption option) {
        return (Double)this.get(option);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option) {
        return (String)this.get(option);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option) {
        return (Map)this.get(option);
    }

    @Override
    public long getBytes(@NonNull DriverOption option) {
        return (Long)this.get(option);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option) {
        return (Duration)this.get(option);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option) {
        return (List)this.get(option);
    }

    @Override
    @NonNull
    public Object getComparisonKey(@NonNull DriverOption option) {
        String prefix = option.getPath();
        ImmutableMap.Builder childOptions = ImmutableMap.builder();
        for (Map.Entry entry : this.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            childOptions.put((Object)((String)entry.getKey()), entry.getValue());
        }
        return childOptions.build();
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Map.Entry.comparingByKey());
        for (Map backingMap : ImmutableList.of(this.overrides, this.profile, this.defaultProfile)) {
            for (Map.Entry entry : backingMap.entrySet()) {
                if (entry.getValue() == NO_VALUE) continue;
                builder.add(new AbstractMap.SimpleEntry(((DriverOption)entry.getKey()).getPath(), entry.getValue()));
            }
        }
        return builder.build();
    }

    private DriverExecutionProfile with(@NonNull DriverOption option, Object value) {
        ImmutableMap.Builder newOverrides = ImmutableMap.builder();
        for (Map.Entry<DriverOption, Object> override : this.overrides.entrySet()) {
            if (override.getKey().equals(option)) continue;
            newOverrides.put((Object)override.getKey(), override.getValue());
        }
        newOverrides.put((Object)option, value);
        return new MapBasedDriverExecutionProfile(this.profileName, (Map<DriverOption, Object>)newOverrides.build(), this.profile, this.defaultProfile);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBoolean(@NonNull DriverOption option, boolean value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBooleanList(@NonNull DriverOption option, @NonNull List<Boolean> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withInt(@NonNull DriverOption option, int value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withIntList(@NonNull DriverOption option, @NonNull List<Integer> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withLong(@NonNull DriverOption option, long value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withLongList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDouble(@NonNull DriverOption option, double value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDoubleList(@NonNull DriverOption option, @NonNull List<Double> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withString(@NonNull DriverOption option, @NonNull String value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withStringList(@NonNull DriverOption option, @NonNull List<String> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withStringMap(@NonNull DriverOption option, @NonNull Map<String, String> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBytes(@NonNull DriverOption option, long value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withBytesList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDuration(@NonNull DriverOption option, @NonNull Duration value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile withDurationList(@NonNull DriverOption option, @NonNull List<Duration> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public DriverExecutionProfile without(@NonNull DriverOption option) {
        return this.with(option, NO_VALUE);
    }
}

