/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DaoBase {
    public static final String KEYSPACE_ID_PLACEHOLDER = "${keyspaceId}";
    public static final String TABLE_ID_PLACEHOLDER = "${tableId}";
    public static final String QUALIFIED_TABLE_ID_PLACEHOLDER = "${qualifiedTableId}";
    private static final CqlIdentifier APPLIED = CqlIdentifier.fromInternal((String)"[applied]");
    protected final MapperContext context;
    protected final boolean isProtocolVersionV3;

    protected static CompletionStage<PreparedStatement> prepare(SimpleStatement statement, MapperContext context) {
        if (context.getExecutionProfileName() != null) {
            statement = (SimpleStatement)statement.setExecutionProfileName(context.getExecutionProfileName());
        } else if (context.getExecutionProfile() != null) {
            statement = (SimpleStatement)statement.setExecutionProfile(context.getExecutionProfile());
        }
        return context.getSession().prepareAsync(statement);
    }

    protected static SimpleStatement replaceKeyspaceAndTablePlaceholders(String queryStringTemplate, MapperContext context, EntityHelper<?> entityHelper) {
        CqlIdentifier keyspaceId = entityHelper != null ? entityHelper.getKeyspaceId() : context.getKeyspaceId();
        CqlIdentifier tableId = entityHelper != null ? entityHelper.getTableId() : context.getTableId();
        String queryString = queryStringTemplate;
        if (queryString.contains(KEYSPACE_ID_PLACEHOLDER)) {
            if (keyspaceId == null) {
                throw new MapperException(String.format("Cannot substitute %s in query '%s': the DAO wasn't built with a keyspace%s", KEYSPACE_ID_PLACEHOLDER, queryStringTemplate, entityHelper == null ? "" : " and entity " + entityHelper.getEntityClass().getSimpleName() + " does not define a default keyspace"));
            }
            queryString = queryString.replace(KEYSPACE_ID_PLACEHOLDER, keyspaceId.asCql(false));
        }
        if (queryString.contains(TABLE_ID_PLACEHOLDER)) {
            if (tableId == null) {
                throw new MapperException(String.format("Cannot substitute %s in query '%s': the DAO wasn't built with a table", TABLE_ID_PLACEHOLDER, queryStringTemplate));
            }
            queryString = queryString.replace(TABLE_ID_PLACEHOLDER, tableId.asCql(false));
        }
        if (queryString.contains(QUALIFIED_TABLE_ID_PLACEHOLDER)) {
            if (tableId == null) {
                throw new MapperException(String.format("Cannot substitute %s in query '%s': the DAO wasn't built with a table", QUALIFIED_TABLE_ID_PLACEHOLDER, queryStringTemplate));
            }
            String qualifiedId = keyspaceId == null ? tableId.asCql(false) : keyspaceId.asCql(false) + '.' + tableId.asCql(false);
            queryString = queryString.replace(QUALIFIED_TABLE_ID_PLACEHOLDER, qualifiedId);
        }
        return SimpleStatement.newInstance((String)queryString);
    }

    public BoundStatementBuilder populateBoundStatementWithStatementAttributes(BoundStatementBuilder builder, String profileName, String consistencyLevel, String serialConsistencyLevel, Boolean idempotent, int pageSize, String timeout, String keyspace) {
        if (!profileName.isEmpty()) {
            builder = (BoundStatementBuilder)builder.setExecutionProfileName(profileName);
        }
        if (!consistencyLevel.isEmpty()) {
            builder = (BoundStatementBuilder)builder.setConsistencyLevel(this.getConsistencyLevelFromName(consistencyLevel));
        }
        if (!serialConsistencyLevel.isEmpty()) {
            builder = (BoundStatementBuilder)builder.setSerialConsistencyLevel(this.getConsistencyLevelFromName(serialConsistencyLevel));
        }
        if (idempotent != null) {
            builder = (BoundStatementBuilder)builder.setIdempotence(idempotent);
        }
        if (pageSize > 0) {
            builder = (BoundStatementBuilder)builder.setPageSize(pageSize);
        }
        if (!timeout.isEmpty()) {
            builder = (BoundStatementBuilder)builder.setTimeout(Duration.parse(timeout));
        }
        if (!keyspace.isEmpty()) {
            builder = (BoundStatementBuilder)builder.setRoutingKeyspace(keyspace);
        }
        return builder;
    }

    private ConsistencyLevel getConsistencyLevelFromName(String name) {
        InternalDriverContext idContext = (InternalDriverContext)this.context.getSession().getContext();
        ConsistencyLevelRegistry registry = idContext.getConsistencyLevelRegistry();
        return registry.codeToLevel(registry.nameToCode(name));
    }

    protected DaoBase(MapperContext context) {
        this.context = context;
        this.isProtocolVersionV3 = DaoBase.isProtocolVersionV3(context);
    }

    protected ResultSet execute(Statement<?> statement) {
        return this.context.getSession().execute(statement);
    }

    protected boolean executeAndMapWasAppliedToBoolean(Statement<?> statement) {
        ResultSet rs = this.execute(statement);
        return rs.wasApplied();
    }

    protected long executeAndMapFirstColumnToLong(Statement<?> statement) {
        Row row = this.executeAndExtractFirstRow(statement);
        return this.extractCount(row);
    }

    private long extractCount(Row row) {
        if (row == null) {
            throw new MapperException("Expected the query to return at least one row (return type long is intended for COUNT queries)");
        }
        if (row.getColumnDefinitions().size() == 0 || !row.getColumnDefinitions().get(0).getType().equals(DataTypes.BIGINT)) {
            throw new MapperException("Expected the query to return a column with CQL type BIGINT in first position (return type long is intended for COUNT queries)");
        }
        return row.getLong(0);
    }

    protected Row executeAndExtractFirstRow(Statement<?> statement) {
        return (Row)this.execute(statement).one();
    }

    protected <EntityT> EntityT executeAndMapToSingleEntity(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        ResultSet rs = this.execute(statement);
        return this.asEntity((Row)rs.one(), entityHelper);
    }

    private <EntityT> EntityT asEntity(Row row, EntityHelper<EntityT> entityHelper) {
        return row == null || row.getColumnDefinitions().size() == 1 && row.getColumnDefinitions().get(0).getName().equals((Object)APPLIED) ? null : (EntityT)entityHelper.get((GettableByName)row, false);
    }

    protected <EntityT> Optional<EntityT> executeAndMapToOptionalEntity(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return Optional.ofNullable(this.executeAndMapToSingleEntity(statement, entityHelper));
    }

    protected <EntityT> PagingIterable<EntityT> executeAndMapToEntityIterable(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return this.execute(statement).map(row -> entityHelper.get((GettableByName)row, false));
    }

    protected <EntityT> Stream<EntityT> executeAndMapToEntityStream(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return StreamSupport.stream(this.execute(statement).map(row -> entityHelper.get((GettableByName)row, false)).spliterator(), false);
    }

    protected CompletableFuture<AsyncResultSet> executeAsync(Statement<?> statement) {
        CompletionStage stage = this.context.getSession().executeAsync(statement);
        return stage.toCompletableFuture();
    }

    protected CompletableFuture<Void> executeAsyncAndMapToVoid(Statement<?> statement) {
        return this.executeAsync(statement).thenApply(rs -> null);
    }

    protected CompletableFuture<Boolean> executeAsyncAndMapWasAppliedToBoolean(Statement<?> statement) {
        return this.executeAsync(statement).thenApply(AsyncResultSet::wasApplied);
    }

    protected CompletableFuture<Long> executeAsyncAndMapFirstColumnToLong(Statement<?> statement) {
        return this.executeAsyncAndExtractFirstRow(statement).thenApply(this::extractCount);
    }

    protected CompletableFuture<Row> executeAsyncAndExtractFirstRow(Statement<?> statement) {
        return this.executeAsync(statement).thenApply(AsyncPagingIterable::one);
    }

    protected <EntityT> CompletableFuture<EntityT> executeAsyncAndMapToSingleEntity(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return this.executeAsync(statement).thenApply(rs -> this.asEntity((Row)rs.one(), entityHelper));
    }

    protected <EntityT> CompletableFuture<Optional<EntityT>> executeAsyncAndMapToOptionalEntity(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return this.executeAsync(statement).thenApply(rs -> Optional.ofNullable(this.asEntity((Row)rs.one(), entityHelper)));
    }

    protected <EntityT> CompletableFuture<MappedAsyncPagingIterable<EntityT>> executeAsyncAndMapToEntityIterable(Statement<?> statement, EntityHelper<EntityT> entityHelper) {
        return this.executeAsync(statement).thenApply(rs -> rs.map(row -> entityHelper.get((GettableByName)row, false)));
    }

    protected static void throwIfProtocolVersionV3(MapperContext context) {
        if (DaoBase.isProtocolVersionV3(context)) {
            throw new MapperException(String.format("You cannot use %s.%s for protocol version V3.", NullSavingStrategy.class.getSimpleName(), NullSavingStrategy.DO_NOT_SET.name()));
        }
    }

    protected static boolean isProtocolVersionV3(MapperContext context) {
        return context.getSession().getContext().getProtocolVersion().getCode() <= 3;
    }
}

