/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.com.datastax.oss.driver.shaded.guava/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Ascii}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.CaseFormat}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.CharMatcher}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Charsets}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Joiner}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Splitter}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Function}, {@link com.datastax.oss.driver.shaded.guava.common.base.Functions}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Predicate}, {@link com.datastax.oss.driver.shaded.guava.common.base.Predicates}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Equivalence}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Converter}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Supplier}, {@link com.datastax.oss.driver.shaded.guava.common.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Defaults}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Enums}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Objects}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Optional}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Preconditions}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Stopwatch}
 *   <li>{@link com.datastax.oss.driver.shaded.guava.common.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package com.datastax.oss.driver.shaded.guava.common.base;

import com.datastax.oss.driver.shaded.guava.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
