/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.util.DriverUtil$;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class LocalNodeFirstLoadBalancingPolicy$ {
    public static final LocalNodeFirstLoadBalancingPolicy$ MODULE$;
    private final Random com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$random;
    private final Set<InetAddress> com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$localAddresses;
    private final DriverOption LoadBalancingShuffleNodes;

    static {
        new LocalNodeFirstLoadBalancingPolicy$();
    }

    public Random com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$random() {
        return this.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$random;
    }

    public Set<InetAddress> com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$localAddresses() {
        return this.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$localAddresses;
    }

    public boolean isLocalHost(Node node) {
        return DriverUtil$.MODULE$.toAddress(node).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InetSocketAddress hostAddress) {
                return hostAddress.getAddress().isLoopbackAddress() || LocalNodeFirstLoadBalancingPolicy$.MODULE$.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$localAddresses().contains((Object)hostAddress.getAddress());
            }
        });
    }

    public Seq<Node> sortNodesByStatusAndProximity(String dc, Set<Node> nodesToSort) {
        Map grouped = (Map)nodesToSort.groupBy((Function1)new Serializable(dc){
            public static final long serialVersionUID = 0L;
            private final String dc$1;

            public final Option<Object> apply(Node x0$1) {
                None$ none$;
                Node node = x0$1;
                String string = node.getDatacenter();
                String string2 = this.dc$1;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    NodeState nodeState = node.getState();
                    NodeState nodeState2 = NodeState.UP;
                    none$ = !(nodeState != null ? !nodeState.equals(nodeState2) : nodeState2 != null) ? (LocalNodeFirstLoadBalancingPolicy$.MODULE$.isLocalHost(node) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : new Some((Object)BoxesRunTime.boxToInteger((int)1))) : new Some((Object)BoxesRunTime.boxToInteger((int)2));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                this.dc$1 = dc$1;
            }
        }).$minus((Object)None$.MODULE$);
        return (Seq)((TraversableLike)grouped.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Option<Object>, Set<Node>> x$10) {
                return BoxesRunTime.unboxToInt((Object)((Option)x$10._1()).get());
            }
        }, (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Node> apply(Tuple2<Option<Object>, Set<Node>> x0$2) {
                Tuple2<Option<Object>, Set<Node>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Set nodes = (Set)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)LocalNodeFirstLoadBalancingPolicy$.MODULE$.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$random().shuffle((TraversableOnce)nodes.toIndexedSeq(), IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String determineDataCenter(Set<InetSocketAddress> contactPoints, Set<Node> allNodes) {
        Set maybeResolved = (Set)contactPoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InetSocketAddress apply(InetSocketAddress x) {
                return x.isUnresolved() ? new InetSocketAddress(x.getHostString(), x.getPort()) : x;
            }
        }, Set$.MODULE$.canBuildFrom());
        Set dcs = (Set)((TraversableLike)allNodes.filter((Function1)new Serializable(maybeResolved){
            public static final long serialVersionUID = 0L;
            public final Set maybeResolved$1;

            public final boolean apply(Node node) {
                return DriverUtil$.MODULE$.toAddress(node).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.8 $outer;

                    public final boolean apply(InetSocketAddress elem) {
                        return this.$outer.maybeResolved$1.contains((Object)elem);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.maybeResolved$1 = maybeResolved$1;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Node node) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)node.getDatacenter()));
            }
        }, Set$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(dcs.nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "There are no contact points in the given set of hosts";
            }
        });
        Predef$.MODULE$.require(dcs.size() == 1, (Function0)new Serializable(dcs){
            public static final long serialVersionUID = 0L;
            private final Set dcs$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Contact points contain multiple data centers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dcs$1.mkString(", ")}));
            }
            {
                this.dcs$1 = dcs$1;
            }
        });
        return (String)dcs.head();
    }

    public DriverOption LoadBalancingShuffleNodes() {
        return this.LoadBalancingShuffleNodes;
    }

    private LocalNodeFirstLoadBalancingPolicy$() {
        MODULE$ = this;
        this.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$random = new Random();
        this.com$datastax$spark$connector$cql$LocalNodeFirstLoadBalancingPolicy$$localAddresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<InetAddress> apply(NetworkInterface x$9) {
                return (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(x$9.getInetAddresses()).asScala();
            }
        }).toSet();
        this.LoadBalancingShuffleNodes = new DriverOption(){

            public String getPath() {
                return "basic.load-balancing-policy.shuffle-replicas";
            }
        };
    }
}

