/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.spark.connector.util.DriverUtil$;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class LocalNodeFirstLoadBalancingPolicy$ {
    public static LocalNodeFirstLoadBalancingPolicy$ MODULE$;
    private final Random random;
    private final Set<InetAddress> localAddresses;
    private final DriverOption LoadBalancingShuffleNodes;

    static {
        new LocalNodeFirstLoadBalancingPolicy$();
    }

    private Random random() {
        return this.random;
    }

    private Set<InetAddress> localAddresses() {
        return this.localAddresses;
    }

    public boolean isLocalHost(Node node) {
        return DriverUtil$.MODULE$.toAddress(node).exists((Function1 & Serializable & scala.Serializable)hostAddress -> BoxesRunTime.boxToBoolean((boolean)LocalNodeFirstLoadBalancingPolicy$.$anonfun$isLocalHost$1(hostAddress)));
    }

    public Seq<Node> sortNodesByStatusAndProximity(String dc, Set<Node> nodesToSort) {
        Map grouped = (Map)nodesToSort.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Node node = x0$1;
            String string = node.getDatacenter();
            String string2 = dc;
            if (string == null ? string2 != null : !string.equals(string2)) {
                none$ = None$.MODULE$;
            } else {
                NodeState nodeState = node.getState();
                NodeState nodeState2 = NodeState.UP;
                none$ = (nodeState == null ? nodeState2 != null : !nodeState.equals(nodeState2)) ? new Some((Object)BoxesRunTime.boxToInteger((int)2)) : (!MODULE$.isLocalHost(node) ? new Some((Object)BoxesRunTime.boxToInteger((int)1)) : new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            return none$;
        }).$minus((Object)None$.MODULE$);
        return (Seq)((TraversableLike)grouped.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)LocalNodeFirstLoadBalancingPolicy$.$anonfun$sortNodesByStatusAndProximity$2(x$10)), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set nodes = (Set)tuple2._2();
            IndexedSeq indexedSeq = (IndexedSeq)MODULE$.random().shuffle((TraversableOnce)nodes.toIndexedSeq(), IndexedSeq$.MODULE$.canBuildFrom());
            return indexedSeq;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String determineDataCenter(Set<InetSocketAddress> contactPoints, Set<Node> allNodes) {
        Set maybeResolved = (Set)contactPoints.map((Function1 & Serializable & scala.Serializable)x -> x.isUnresolved() ? new InetSocketAddress(x.getHostString(), x.getPort()) : x, Set$.MODULE$.canBuildFrom());
        Set dcs = (Set)((TraversableLike)allNodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)LocalNodeFirstLoadBalancingPolicy$.$anonfun$determineDataCenter$2(maybeResolved, node)))).flatMap((Function1 & Serializable & scala.Serializable)node -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)node.getDatacenter())), Set$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(dcs.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "There are no contact points in the given set of hosts");
        Predef$.MODULE$.require(dcs.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Contact points contain multiple data centers: ").append(dcs.mkString(", ")).toString());
        return (String)dcs.head();
    }

    public DriverOption LoadBalancingShuffleNodes() {
        return this.LoadBalancingShuffleNodes;
    }

    public static final /* synthetic */ boolean $anonfun$isLocalHost$1(InetSocketAddress hostAddress) {
        return hostAddress.getAddress().isLoopbackAddress() || MODULE$.localAddresses().contains((Object)hostAddress.getAddress());
    }

    public static final /* synthetic */ int $anonfun$sortNodesByStatusAndProximity$2(Tuple2 x$10) {
        return BoxesRunTime.unboxToInt((Object)((Option)x$10._1()).get());
    }

    public static final /* synthetic */ boolean $anonfun$determineDataCenter$2(Set maybeResolved$1, Node node) {
        return DriverUtil$.MODULE$.toAddress(node).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)maybeResolved$1.contains((Object)elem)));
    }

    private LocalNodeFirstLoadBalancingPolicy$() {
        MODULE$ = this;
        this.random = new Random();
        this.localAddresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(x$9.getInetAddresses()).asScala()).toSet();
        this.LoadBalancingShuffleNodes = new DriverOption(){

            public String getPath() {
                return "basic.load-balancing-policy.shuffle-replicas";
            }
        };
    }
}

